/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseElement {
    public static final String OK = "ok";
    private final List<ResponseElement> children = new ArrayList<ResponseElement>();
    private final ResponseElement parent;
    private String childType = null;
    private String name = null;
    private Object value = null;
    private boolean hasRawValue = false;

    public ResponseElement(ResponseElement parent) {
        this(null, parent);
    }

    public ResponseElement(String name, ResponseElement parent) {
        this.name = name;
        this.parent = parent;
    }

    public ResponseElement childType(String childType) {
        this.childType = childType;
        return this;
    }

    public ResponseElement children(Collection values) {
        for (Object value : values) {
            this.child(value);
        }
        return this;
    }

    public ResponseElement children(long[] values) {
        long[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long value = arr$[i$];
            this.child(value);
        }
        return this;
    }

    public ResponseElement children(String ... values) {
        for (String value : values) {
            this.child(value);
        }
        return this;
    }

    public ResponseElement child(Object value) {
        return this.begin(null).value(value).end();
    }

    public ResponseElement child(String name, Object value) {
        return this.begin(name).value(value).end();
    }

    public ResponseElement begin(String name) {
        if (this.value != null) {
            throw new IllegalArgumentException("The element '" + name + "' has a child being add while it already has a value");
        }
        ResponseElement child = new ResponseElement(this);
        child.name(name);
        this.children.add(child);
        return child;
    }

    public ResponseElement end() {
        return this.parent;
    }

    public ResponseElement name(String name) {
        this.name = name;
        return this;
    }

    public ResponseElement value(Object value) {
        if (!this.children.isEmpty()) {
            throw new IllegalArgumentException("The element '" + this.name + "' has a value being set while it already has children");
        }
        this.value = value;
        return this;
    }

    public ResponseElement rawValue(boolean flag) {
        this.hasRawValue = flag;
        return this;
    }

    public ResponseElement ok() {
        return this.value(OK);
    }

    public String getChildType() {
        return this.childType;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public ResponseElement getParent() {
        return this.parent;
    }

    public List<ResponseElement> getChildren() {
        return this.children;
    }

    public boolean hasChildType() {
        return this.childType != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasRawValue() {
        return this.hasRawValue;
    }
}

