/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.license.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import org.terracotta.ehcachedx.license.util.LicenseException;
import org.terracotta.ehcachedx.license.util.LicenseField;

public class TerracottaLicenseField
implements LicenseField {
    protected final String name;
    protected Object value;
    protected final String type;
    protected final String pattern;
    protected final boolean required;
    protected final Map range;

    public TerracottaLicenseField(String name, String type, String pattern, boolean required, Map range) {
        this.name = name;
        this.type = type;
        this.pattern = pattern;
        this.required = required;
        this.range = range;
    }

    public void setRawValue(String rawValue) throws LicenseException {
        this.value = this.convertAndValidate(rawValue);
    }

    public Object getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Map getRange() {
        return this.range;
    }

    private Object convertAndValidate(String rawValue) throws LicenseException {
        if ("String".equals(this.type)) {
            return this.convertToString(rawValue);
        }
        if ("Integer".equals(this.type)) {
            return this.convertToInteger(rawValue);
        }
        if ("Date".equals(this.type)) {
            return this.convertToDate(rawValue);
        }
        throw new LicenseException("Type '" + this.type + "' isn't recognized");
    }

    private String convertToString(String rawValue) throws LicenseException {
        if (TerracottaLicenseField.isBlank(rawValue)) {
            if (this.required) {
                throw new LicenseException("Field '" + this.name + "' is required");
            }
            return null;
        }
        if (this.pattern != null && !Pattern.matches(this.pattern, rawValue)) {
            throw new LicenseException("Field '" + this.name + "' doesn't match pattern '" + this.pattern + "'");
        }
        return rawValue;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private Integer convertToInteger(String rawValue) throws LicenseException {
        Integer intValue;
        if (TerracottaLicenseField.isBlank(rawValue)) {
            if (this.required) {
                throw new LicenseException("Field '" + this.name + "' is required");
            }
            return null;
        }
        try {
            intValue = Integer.valueOf(rawValue);
        }
        catch (Exception e) {
            throw new LicenseException("Field '" + this.name + "' requires integer value", e);
        }
        if (this.range != null) {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;
            String minS = (String)this.range.get("min");
            String maxS = (String)this.range.get("max");
            if (minS != null) {
                min = Integer.valueOf(minS);
            }
            if (maxS != null) {
                max = Integer.valueOf(maxS);
            }
            if (intValue < min || intValue > max) {
                throw new LicenseException("Field '" + this.name + "' is not within range " + this.range);
            }
        }
        return intValue;
    }

    private Date convertToDate(String rawValue) throws LicenseException {
        if (TerracottaLicenseField.isBlank(rawValue)) {
            if (this.required) {
                throw new LicenseException("Field '" + this.name + "' is required");
            }
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setLenient(false);
        try {
            return df.parse(rawValue);
        }
        catch (ParseException e) {
            throw new LicenseException("Can't parse field '" + this.name + "' with pattern '" + "yyyy-MM-dd".toUpperCase() + "'");
        }
    }

    public String toString() {
        return this.name + " = " + this.value;
    }
}

