/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.license.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.terracotta.ehcachedx.license.Capability;
import org.terracotta.ehcachedx.license.util.LicenseField;
import org.terracotta.ehcachedx.license.util.TerracottaLicenseField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseDescriptor {
    private final Map descriptor = new HashMap(){
        {
            this.put("Enterprise License Description", new HashMap(){
                {
                    this.put("Product", new HashMap(){
                        {
                            this.put("pattern", "Ehcache Monitor");
                            this.put("required", String.valueOf(true));
                            this.put("type", "String");
                        }
                    });
                    this.put("License type", new HashMap(){
                        {
                            this.put("pattern", "DevOnly|Trial|Commercial");
                            this.put("required", String.valueOf(true));
                            this.put("type", "String");
                        }
                    });
                    this.put("License number", new HashMap(){
                        {
                            this.put("required", String.valueOf(true));
                            this.put("type", "String");
                        }
                    });
                    this.put("Expiration date", new HashMap(){
                        {
                            this.put("required", String.valueOf(false));
                            this.put("type", "Date");
                        }
                    });
                    this.put("Licensee", new HashMap(){
                        {
                            this.put("required", String.valueOf(true));
                            this.put("type", "String");
                        }
                    });
                }
            });
            this.put("Licensed products", new HashMap(){
                {
                    this.put("Ehcache Monitor", new ArrayList(){
                        {
                            this.add("monitor");
                        }
                    });
                }
            });
            this.put("Enterprise capabilities", new ArrayList(){
                {
                    this.add("monitor");
                }
            });
        }
    };
    private final Map descriptionMap = (Map)LicenseDescriptor.get(this.descriptor, "Enterprise License Description");

    public EnumSet<Capability> getLicensedCapabilities(String product) {
        Map licensedProducts = (Map)LicenseDescriptor.get(this.descriptor, "Licensed products");
        List values = (List)LicenseDescriptor.get(licensedProducts, product);
        return this.convertToCapabilitySet(values);
    }

    public EnumSet<Capability> getEnterpriseCapabilities() {
        List values = (List)LicenseDescriptor.get(this.descriptor, "Enterprise capabilities");
        return this.convertToCapabilitySet(values);
    }

    public Map getDescriptionMap() {
        return this.descriptionMap;
    }

    public LicenseField createField(String fieldName) {
        Map fieldMap = (Map)LicenseDescriptor.get(this.descriptionMap, fieldName);
        String type = (String)LicenseDescriptor.get(fieldMap, "type");
        String pattern = (String)fieldMap.get("pattern");
        boolean required = Boolean.valueOf((String)LicenseDescriptor.get(fieldMap, "required"));
        Map range = (Map)fieldMap.get("range");
        return new TerracottaLicenseField(fieldName, type, pattern, required, range);
    }

    public List<LicenseField> getFields() {
        ArrayList<LicenseField> list = new ArrayList<LicenseField>();
        Set fieldNames = this.descriptionMap.keySet();
        for (String fieldName : fieldNames) {
            LicenseField field = this.createField(fieldName);
            list.add(field);
        }
        return list;
    }

    private static Object get(Map map, String key) {
        Object value = map.get(key);
        if (value != null) {
            return value;
        }
        throw new RuntimeException("Field " + key + " couldn't be found in descriptor");
    }

    private EnumSet<Capability> convertToCapabilitySet(List values) {
        EnumSet<Capability> result = EnumSet.noneOf(Capability.class);
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Capability c = Capability.parse((String)it.next());
            result.add(c);
        }
        return result;
    }
}

