/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.license.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.terracotta.ehcachedx.license.License;
import org.terracotta.ehcachedx.license.LicenseFactory;
import org.terracotta.ehcachedx.license.util.IOUtils;
import org.terracotta.ehcachedx.license.util.LicenseException;
import org.terracotta.ehcachedx.license.util.LicenseFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheLicenseFormat
implements LicenseFormat {
    private static final String LICENSE_HEADER = "------------------ BEGIN EHCACHE DX LICENSE KEY ------------------";
    private static final String LICENSE_SIGNATURE = "-------------------------- BEGIN SIGNATURE -----------------------";
    private static final String LICENSE_FOOTER = "------------------- END EHCACHE DX LICENSE KEY -------------------";

    @Override
    public void store(License license, OutputStream out) {
        this.store(license, new PrintWriter(out, true));
    }

    public void store(License license, PrintWriter writer) {
        writer.println(LICENSE_HEADER);
        writer.println(((Object)license).toString());
        writer.println(LICENSE_SIGNATURE);
        writer.println(license.getSignature());
        writer.println(LICENSE_FOOTER);
    }

    @Override
    public License load(InputStream in) throws LicenseException, IOException {
        List<String> lines = IOUtils.readLines(in);
        int headerIndex = lines.indexOf(LICENSE_HEADER);
        int footerIndex = lines.indexOf(LICENSE_FOOTER);
        int signatureIndex = lines.indexOf(LICENSE_SIGNATURE);
        if (headerIndex < 0 || footerIndex < 0 || signatureIndex < 0) {
            throw new LicenseException("Product key structure has been compromised.");
        }
        List<String> properties = lines.subList(headerIndex + 1, signatureIndex);
        String signatureString = lines.get(signatureIndex + 1);
        Map<String, String> fields = EhcacheLicenseFormat.extractLicenseFields(properties);
        License license = EhcacheLicenseFormat.getLicenseFromFields(fields);
        license.setSignature(signatureString);
        return license;
    }

    private static Map<String, String> extractLicenseFields(List<String> lines) {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        for (String line : lines) {
            if (line.trim().length() == 0) continue;
            String[] tokens = line.split("=", 2);
            fieldsMap.put(tokens[0].trim(), tokens[1].trim());
        }
        return fieldsMap;
    }

    private static License getLicenseFromFields(Map<String, String> fields) throws LicenseException {
        String type = fields.get("License type");
        String number = fields.get("License number");
        String licensee = fields.get("Licensee");
        String product = fields.get("Product");
        String expirationDate = fields.get("Expiration date");
        String capabilities = fields.get("Capabilities");
        return LicenseFactory.createEnterpriseLicense(type, number, licensee, product, expirationDate, capabilities);
    }
}

