/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.license;

import java.util.Date;
import java.util.EnumSet;
import org.terracotta.ehcachedx.license.Capabilities;
import org.terracotta.ehcachedx.license.Capability;
import org.terracotta.ehcachedx.license.EnterpriseLicense;
import org.terracotta.ehcachedx.license.util.LicenseDescriptor;
import org.terracotta.ehcachedx.license.util.LicenseException;
import org.terracotta.ehcachedx.license.util.LicenseField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseFactory {
    private static final LicenseDescriptor descriptor = new LicenseDescriptor();

    public static EnterpriseLicense createEnterpriseLicense(String licenseType, String licenseNumber, String licensee, String product, String expirationDate) throws LicenseException {
        LicenseField productField = LicenseFactory.createField("Product", product);
        EnumSet<Capability> licensedCapabilities = descriptor.getLicensedCapabilities((String)productField.getValue());
        return LicenseFactory.createLicense(licenseType, licenseNumber, licensee, product, expirationDate, licensedCapabilities);
    }

    public static EnterpriseLicense createEnterpriseLicense(String licenseType, String licenseNumber, String licensee, String product, String expirationDate, String licensedCapabilities) throws LicenseException {
        return LicenseFactory.createLicense(licenseType, licenseNumber, licensee, product, expirationDate, Capability.toSet(licensedCapabilities));
    }

    private static EnterpriseLicense createLicense(String type, String number, String licensee, String product, String expirationDate, EnumSet<Capability> licensedCapabilities) throws LicenseException {
        LicenseField typeField = LicenseFactory.createField("License type", type);
        LicenseField numberField = LicenseFactory.createField("License number", number);
        LicenseField licenseeField = LicenseFactory.createField("Licensee", licensee);
        LicenseField productField = LicenseFactory.createField("Product", product);
        LicenseField expiredDateField = LicenseFactory.createField("Expiration date", expirationDate);
        Capabilities capabilities = new Capabilities(licensedCapabilities, new LicenseDescriptor().getEnterpriseCapabilities());
        EnterpriseLicense license = new EnterpriseLicense((String)typeField.getValue(), (String)numberField.getValue(), (String)licenseeField.getValue(), (String)productField.getValue(), (Date)expiredDateField.getValue(), capabilities);
        return license;
    }

    private static LicenseField createField(String name, String value) throws LicenseException {
        LicenseField field = descriptor.createField(name);
        field.setRawValue(value);
        return field;
    }
}

