/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.license;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.terracotta.ehcachedx.license.Capabilities;
import org.terracotta.ehcachedx.license.License;

public final class EnterpriseLicense
implements License {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final String licenseType;
    private final String licenseNumber;
    private final String licensee;
    private final String product;
    private final Date expirationDate;
    private final Capabilities capabilities;
    private String signature;

    public EnterpriseLicense(String type, String number, String licensee, String product, Date expirationDate, Capabilities capabilities) {
        this.licenseType = type;
        this.licenseNumber = number;
        this.licensee = licensee;
        this.product = product;
        this.capabilities = capabilities;
        this.expirationDate = expirationDate != null ? new Date(expirationDate.getTime()) : null;
    }

    public Date expirationDate() {
        return this.expirationDate != null ? new Date(this.expirationDate.getTime()) : null;
    }

    public boolean isExpired() {
        if (this.expirationDate == null) {
            return false;
        }
        return new Date().after(this.expirationDate);
    }

    public String licenseNumber() {
        return this.licenseNumber;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public String licensee() {
        return this.licensee;
    }

    public String product() {
        return this.product;
    }

    public Capabilities capabilities() {
        return this.capabilities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("License type").append(" = ").append(this.licenseType).append(NEWLINE);
        sb.append("License number").append(" = ").append(this.licenseNumber).append(NEWLINE);
        sb.append("Licensee").append(" = ").append(this.licensee).append(NEWLINE);
        sb.append("Product").append(" = ").append(this.product).append(NEWLINE);
        sb.append("Capabilities").append(" = ").append(this.capabilities.getLicensedCapabilitiesAsString()).append(NEWLINE);
        if (this.expirationDate != null) {
            sb.append("Expiration date").append(" = ").append(EnterpriseLicense.dateToString(this.expirationDate)).append(NEWLINE);
        }
        return sb.toString();
    }

    private static String dateToString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public final byte[] getCanonicalData() {
        StringBuilder sb = new StringBuilder();
        sb.append("License type").append(this.licenseType);
        sb.append("License number").append(this.licenseNumber);
        sb.append("Licensee").append(this.licensee);
        sb.append("Product").append(this.product);
        sb.append("Capabilities").append(this.capabilities.getLicensedCapabilitiesAsString());
        if (this.expirationDate != null) {
            sb.append("Expiration date").append(EnterpriseLicense.dateToString(this.expirationDate));
        }
        try {
            return sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

