/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.license;

import java.util.EnumSet;
import org.terracotta.ehcachedx.license.Capability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Capabilities {
    private final EnumSet<Capability> licensedCapabilities;
    private final EnumSet<Capability> supportedCapabilities;

    public Capabilities(EnumSet<Capability> licensedCapabilities, EnumSet<Capability> supportedCapabilities) {
        this.licensedCapabilities = licensedCapabilities.clone();
        this.supportedCapabilities = supportedCapabilities.clone();
        if (!this.supportedCapabilities.containsAll(this.licensedCapabilities)) {
            throw new AssertionError((Object)"Licensed capabilities have to be a subset of supported capabilities");
        }
    }

    public boolean isSupported(Capability capability) {
        return this.supportedCapabilities.contains((Object)capability);
    }

    public boolean isLicensed(Capability capability) {
        return this.licensedCapabilities.contains((Object)capability);
    }

    public int licensedCapabilitiesCount() {
        return this.licensedCapabilities.size();
    }

    public String getLicensedCapabilitiesAsString() {
        return Capability.convertToString(this.licensedCapabilities);
    }
}

