/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.com.javabi.sizeof.definition;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Set;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinitionMap;
import org.terracotta.ehcachedx.com.javabi.sizeof.MemoryUtil;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.IgnoreDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectDefinition<I>
extends ClassDefinition<I> {
    private final Class<I> clazz;
    private final long size;
    private final Field[] objectFields;
    private final Field[] primitiveFields;
    private ClassDefinition link = null;

    public ObjectDefinition(Class<I> clazz, ClassDefinitionMap definitionMap) {
        this.clazz = clazz;
        long size = 8L;
        ArrayList<Field> objectFieldList = new ArrayList<Field>();
        ArrayList<Field> primitiveFieldList = new ArrayList<Field>();
        Class<I> type = clazz;
        while (!type.equals(Object.class)) {
            Field[] fields;
            if (definitionMap.contains(type)) {
                ClassDefinition<I> definition = definitionMap.get(type);
                if (definition instanceof IgnoreDefinition) break;
                this.link = definition;
                break;
            }
            for (Field field : fields = type.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                if (field.getType().isPrimitive()) {
                    size += ObjectDefinition.sizeOfPrimitive(field.getType());
                    primitiveFieldList.add(field);
                    continue;
                }
                size += 4L;
                if (definitionMap.shouldIgnoreField(field)) continue;
                field.setAccessible(true);
                objectFieldList.add(field);
            }
            type = type.getSuperclass();
        }
        this.objectFields = objectFieldList.toArray(new Field[objectFieldList.size()]);
        this.primitiveFields = primitiveFieldList.toArray(new Field[primitiveFieldList.size()]);
        this.size = size;
    }

    public final Class<I> getClazz() {
        return this.clazz;
    }

    @Override
    public long sizeOf(I instance) {
        if (this.link != null) {
            return this.link.sizeOf(instance) + this.size;
        }
        return this.size;
    }

    @Override
    public final boolean hasElements(I instance) {
        if (this.link != null && this.link.hasElements(instance)) {
            return true;
        }
        return this.objectFields.length > 0;
    }

    @Override
    public long sizeOfElements(I instance, ClassDefinitionMap definitionMap, Set<Object> instanceSet, long size) throws IllegalAccessException {
        if (this.link != null) {
            size = this.link.sizeOfElements(instance, definitionMap, instanceSet, size);
            size -= 8L;
        }
        for (Field field : this.objectFields) {
            Object value = field.get(instance);
            if (value == null) continue;
            size += MemoryUtil.sizeOf(value, definitionMap, instanceSet);
        }
        return size;
    }

    @Override
    public long sizeOfDebug(I instance, ClassDefinitionMap definitionMap, Set<Object> instanceSet, PrintStream stream) throws IllegalAccessException {
        long objectSize = 8L;
        for (Field field : this.primitiveFields) {
            long fieldSize = ObjectDefinition.sizeOfPrimitive(field.getType());
            stream.println(field.getDeclaringClass().getSimpleName() + "." + field.getName() + " " + fieldSize + " bytes");
        }
        if (this.link != null) {
            objectSize = this.link.sizeOfDebug(instance, definitionMap, instanceSet, stream);
        }
        for (Field field : this.objectFields) {
            Object value = field.get(instance);
            if (value == null) continue;
            long fieldSize = MemoryUtil.sizeOfDebug(value, definitionMap, instanceSet, stream);
            stream.println(field.getDeclaringClass().getSimpleName() + "." + field.getName() + " " + fieldSize + " bytes");
            objectSize += fieldSize;
        }
        stream.println(instance.getClass().getSimpleName() + " " + objectSize + " bytes");
        return objectSize;
    }
}

