/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.com.javabi.sizeof;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinitionInitialisationException;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.BooleanArrayDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.ByteArrayDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.CharArrayDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.DoubleArrayDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.FloatArrayDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.HashMapDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.IgnoreDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.IntArrayDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.LinkedHashMapDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.LinkedListDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.LongArrayDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.ObjectArrayDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.ObjectDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.definition.ShortArrayDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDefinitionMap {
    private final Map<Class<?>, ClassDefinition<?>> classToDefinition = new IdentityHashMap();
    private final Set<Field> ignoreFieldSet = new HashSet<Field>();

    public ClassDefinitionMap() {
        try {
            this.defineRequiredTypes();
            this.defineOptionalTypes();
        }
        catch (Exception e) {
            throw new ClassDefinitionInitialisationException(e);
        }
    }

    protected void defineRequiredTypes() {
        this.defineType(Object[].class, new ObjectArrayDefinition());
        this.defineType(boolean[].class, new BooleanArrayDefinition());
        this.defineType(char[].class, new CharArrayDefinition());
        this.defineType(byte[].class, new ByteArrayDefinition());
        this.defineType(short[].class, new ShortArrayDefinition());
        this.defineType(int[].class, new IntArrayDefinition());
        this.defineType(long[].class, new LongArrayDefinition());
        this.defineType(float[].class, new FloatArrayDefinition());
        this.defineType(double[].class, new DoubleArrayDefinition());
        this.ignoreType(ClassLoader.class);
        this.ignoreType(Class.class);
    }

    protected void defineOptionalTypes() throws Exception {
        this.defineType(LinkedList.class, new LinkedListDefinition());
        this.defineType(HashMap.class, new HashMapDefinition());
        this.defineType(LinkedHashMap.class, new LinkedHashMapDefinition());
    }

    public final <T> void defineType(Class<T> clazz, ClassDefinition<T> definition) {
        if (clazz == null || definition == null) {
            throw new NullPointerException();
        }
        this.classToDefinition.put(clazz, definition);
    }

    public final <T> void ignoreType(Class<T> type) {
        this.defineType(type, new IgnoreDefinition());
    }

    public final void ignoreField(Field field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this.ignoreFieldSet.add(field);
    }

    public final boolean shouldIgnoreField(Field field) {
        return this.ignoreFieldSet.contains(field);
    }

    public final void ignoreField(Class<?> type, String fieldName) throws NoSuchFieldException {
        Field field = type.getDeclaredField(fieldName);
        this.ignoreField(field);
    }

    public final void ignoreField(String className, String fieldName) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> clazz = Class.forName(className);
        this.ignoreField(clazz, fieldName);
    }

    public final <T> ClassDefinition<T> get(Class<T> clazz) {
        ClassDefinition<Object> definition = this.classToDefinition.get(clazz);
        if (definition == null) {
            definition = this.newDefinition(clazz);
            this.classToDefinition.put(clazz, definition);
        }
        return definition;
    }

    public final boolean contains(Class<?> clazz) {
        return this.classToDefinition.containsKey(clazz);
    }

    protected <T> ClassDefinition<T> newDefinition(Class<T> clazz) {
        ClassDefinition definition = Object[].class.isAssignableFrom(clazz) ? new ObjectArrayDefinition() : new ObjectDefinition<T>(clazz, this);
        return definition;
    }
}

