/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.server.api;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Function;
import org.terracotta.entity.StateDumpCollector;
import org.terracotta.entity.StateDumpable;

public class PathResolver
implements StateDumpable {
    private final Path baseDir;
    private final Function<Path, Path> transform;

    private PathResolver() {
        this(Paths.get("", new String[0]), Function.identity());
    }

    public PathResolver(Path baseDir) {
        this(baseDir, Function.identity());
    }

    public PathResolver(Path baseDir, Function<Path, Path> transform) {
        this.baseDir = Objects.requireNonNull(baseDir);
        this.transform = Objects.requireNonNull(transform);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path resolve(Path path) {
        if (path == null) {
            return null;
        }
        Path transformed = this.transform.apply(path);
        if (transformed.isAbsolute()) {
            return path;
        }
        return this.baseDir.resolve(path);
    }

    public String toString() {
        return this.baseDir.toAbsolutePath().toString();
    }

    public void addStateTo(StateDumpCollector stateDumpCollector) {
        stateDumpCollector.addState("baseDir", (Object)this.baseDir.toAbsolutePath().toString());
    }
}

