/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.server.api;

import java.util.Collection;
import java.util.function.Supplier;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceProviderConfiguration;

public interface DynamicConfigExtension {
    default public boolean onlyWhenNodeConfigured() {
        return true;
    }

    public void configure(Registrar var1, PlatformConfiguration var2);

    default public <T> T findService(PlatformConfiguration platformConfiguration, Class<T> type) {
        Collection services = platformConfiguration.getExtendedConfiguration(type);
        if (services.isEmpty()) {
            throw new AssertionError((Object)("No instance of service " + type + " found"));
        }
        if (services.size() == 1) {
            Object instance = services.iterator().next();
            if (instance == null) {
                throw new AssertionError((Object)("Instance of service " + type + " found to be null"));
            }
            return (T)instance;
        }
        throw new AssertionError((Object)("Multiple instances of service " + type + " found"));
    }

    public static interface Registrar {
        default public <T> void registerExtendedConfiguration(Class<T> type, T implementation) {
            this.registerExtendedConfigurationSupplier(type, () -> implementation);
        }

        public <T> void registerExtendedConfigurationSupplier(Class<T> var1, Supplier<T> var2);

        public void registerExtendedConfiguration(Object var1);

        public void registerServiceProviderConfiguration(ServiceProviderConfiguration var1);
    }
}

