/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.server.api;

import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.server.api.InvalidConfigChangeException;

public interface ConfigChangeHandler {
    default public void validate(NodeContext nodeContext, Configuration change) throws InvalidConfigChangeException {
    }

    default public void apply(Configuration change) {
    }

    public static ConfigChangeHandler reject(final String reason) {
        return new ConfigChangeHandler(){

            @Override
            public void validate(NodeContext nodeContext, Configuration change) throws InvalidConfigChangeException {
                throw new InvalidConfigChangeException(reason);
            }

            public String toString() {
                return "ConfigChangeHandler#reject()";
            }
        };
    }

    public static ConfigChangeHandler accept() {
        return new ConfigChangeHandler(){

            public String toString() {
                return "ConfigChangeHandler#accept()";
            }
        };
    }
}

