/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;

public class NodeContext
implements Cloneable {
    private final Cluster cluster;
    private final UID nodeUID;
    private final Node node;
    private final Stripe stripe;

    public NodeContext(Cluster cluster, UID nodeUID) {
        Objects.requireNonNull(nodeUID);
        this.nodeUID = Objects.requireNonNull(nodeUID);
        this.cluster = Objects.requireNonNull(cluster);
        this.node = cluster.getNode(nodeUID).orElseThrow(() -> new IllegalArgumentException("Node UID: " + nodeUID + " not found in cluster: " + cluster.toShapeString()));
        this.stripe = cluster.getStripeByNode(nodeUID).get();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public UID getNodeUID() {
        return this.nodeUID;
    }

    public Node getNode() {
        return this.node;
    }

    public Stripe getStripe() {
        return this.stripe;
    }

    public UID getStripeUID() {
        return this.stripe.getUID();
    }

    public Optional<String> getProperty(Setting setting) {
        return setting.getProperty(this.getObject(setting.getScope()));
    }

    public PropertyHolder getObject(Scope scope) {
        switch (scope) {
            case CLUSTER: {
                return this.getCluster();
            }
            case STRIPE: {
                return this.getStripe();
            }
            case NODE: {
                return this.getNode();
            }
        }
        throw new AssertionError((Object)scope);
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public NodeContext clone() {
        return new NodeContext(this.cluster.clone(), this.nodeUID);
    }

    public String toString() {
        return "NodeContext{cluster=" + this.cluster.toShapeString() + ", nodeUID=" + this.nodeUID + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeContext)) {
            return false;
        }
        NodeContext that = (NodeContext)o;
        return this.getCluster().equals(that.getCluster()) && this.getNodeUID().equals(that.getNodeUID());
    }

    public int hashCode() {
        return Objects.hash(this.getCluster(), this.getNodeUID());
    }

    public Optional<NodeContext> withCluster(Cluster updated) {
        Objects.requireNonNull(updated);
        return updated.containsNode(this.nodeUID) ? Optional.of(new NodeContext(updated, this.nodeUID)) : (updated.containsNode(this.node.getName()) ? Optional.of(new NodeContext(updated, updated.getNodeByName(this.node.getName()).get().getUID())) : updated.getNodes().stream().filter(n -> n.getInternalHostPort().equals((Object)this.node.getInternalHostPort())).map(n -> new NodeContext(updated, n.getUID())).findAny());
    }

    public NodeContext alone() {
        return this.withOnlyNode(this.getNode());
    }

    public NodeContext withOnlyNode(Node node) {
        Stripe stripe = this.getStripe().clone().setNodes(Collections.singletonList(node));
        Cluster cluster = this.getCluster().clone().setStripes(Collections.singletonList(stripe));
        return new NodeContext(cluster, node.getUID());
    }
}

