/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.util.Objects;
import java.util.Random;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Version;
import org.terracotta.dynamic_config.api.service.ClusterValidator;
import org.terracotta.dynamic_config.api.service.NameGenerator;

public class FormatUpgrade {
    public Cluster upgrade(Cluster original, Version from) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(from);
        Cluster upgraded = original.clone();
        if (from == Version.V1) {
            String clusterName = upgraded.getName();
            Objects.requireNonNull(clusterName);
            Random random = new Random(clusterName.hashCode());
            upgraded.setUID(upgraded.newUID(random));
            upgraded.getStripes().forEach(stripe -> {
                stripe.setUID(upgraded.newUID(random));
                stripe.getNodes().forEach(node -> node.setUID(upgraded.newUID(random)));
            });
            NameGenerator.assignFriendlyStripeNames((Cluster)upgraded, (Random)new Random(clusterName.hashCode()));
        }
        new ClusterValidator(upgraded).validate(ClusterState.CONFIGURING);
        return upgraded;
    }
}

