/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.nomad.Applicability;
import org.terracotta.dynamic_config.api.model.nomad.FilteredNomadChange;

public class UnlockConfigNomadChange
extends FilteredNomadChange {
    private final boolean forced;

    public UnlockConfigNomadChange(boolean forced) {
        super(Applicability.cluster());
        this.forced = forced;
    }

    @Override
    public Cluster apply(Cluster original) {
        Cluster updated = original.clone();
        updated.setConfigurationLockContext(null);
        return updated;
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext nodeContext) {
        return true;
    }

    public String getSummary() {
        return String.format("Unlocking the config (forced=%b)", this.forced);
    }

    public boolean isForced() {
        return this.forced;
    }
}

