/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.Applicability;
import org.terracotta.dynamic_config.api.model.nomad.FilteredNomadChange;

public class SettingNomadChange
extends FilteredNomadChange {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingNomadChange.class);
    private final Operation operation;
    private final Setting setting;
    private final String name;
    private final String value;

    protected SettingNomadChange(Applicability applicability, Operation operation, Setting setting, String name, String value) {
        super(applicability);
        this.operation = Objects.requireNonNull(operation);
        this.setting = Objects.requireNonNull(setting);
        this.name = name;
        this.value = value;
    }

    public String getSummary() {
        String s = this.operation == Operation.SET ? (this.name == null ? this.operation + " " + this.setting + "=" + this.value : this.operation + " " + this.setting + "." + this.name + "=" + this.value) : (this.name == null ? this.operation + " " + this.setting : this.operation + " " + this.setting + "." + this.name);
        switch (this.getApplicability().getLevel()) {
            case STRIPE: 
            case NODE: {
                return s + " (on " + this.getApplicability() + ")";
            }
        }
        return s;
    }

    @Override
    public Cluster apply(Cluster original) {
        Configuration configuration = this.toConfiguration(original);
        configuration.validate(ClusterState.ACTIVATED, this.getOperation());
        Cluster updated = original.clone();
        configuration.apply((PropertyHolder)updated);
        return updated;
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext currentNode) {
        boolean vetoFromThisTargetedNode;
        boolean requiresThisTargetedNodeToRestart;
        Configuration configuration = this.toConfiguration(currentNode.getCluster());
        boolean requiresClusterRestart = this.setting.requires(Requirement.CLUSTER_RESTART);
        if (requiresClusterRestart) {
            LOGGER.trace("canUpdateRuntimeTopology({}): NO (cluster requires a restart)", (Object)configuration);
            return false;
        }
        boolean thisNodeIsTargeted = this.getSetting().isScope(Scope.NODE) && this.getApplicability().isApplicableTo(currentNode);
        boolean bl = requiresThisTargetedNodeToRestart = thisNodeIsTargeted && this.setting.requires(Requirement.NODE_RESTART);
        if (requiresThisTargetedNodeToRestart) {
            LOGGER.trace("canUpdateRuntimeTopology({}, {}, {}): NO (this targeted node requires a restart)", new Object[]{configuration, this.getApplicability(), currentNode});
            return false;
        }
        boolean bl2 = vetoFromThisTargetedNode = thisNodeIsTargeted && this.setting.vetoRuntimeChange(currentNode, configuration);
        if (vetoFromThisTargetedNode) {
            LOGGER.trace("canUpdateRuntimeTopology({}, {}, {}): NO (targeted node has vetoed the runtime change and will need to restart)", new Object[]{configuration, this.getApplicability(), currentNode});
        } else {
            LOGGER.trace("canUpdateRuntimeTopology({}, {}, {}): YES", new Object[]{configuration, this.getApplicability(), currentNode});
        }
        return !vetoFromThisTargetedNode;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Setting getSetting() {
        return this.setting;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SettingNomadChange)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SettingNomadChange that = (SettingNomadChange)o;
        return this.getOperation() == that.getOperation() && this.getSetting() == that.getSetting() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getValue(), that.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOperation(), this.getSetting(), this.getName(), this.getValue());
    }

    public String toString() {
        return "SettingNomadChange{operation=" + this.operation + ", setting=" + this.setting + ", name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", applicability=" + this.getApplicability() + '}';
    }

    public Configuration toConfiguration(Cluster cluster) {
        switch (this.operation) {
            case SET: {
                return this.name == null ? Configuration.valueOf((String)(this.namespace(cluster) + this.setting + "=" + this.value)) : Configuration.valueOf((String)(this.namespace(cluster) + this.setting + "." + this.name + "=" + this.value));
            }
            case UNSET: {
                return this.name == null ? Configuration.valueOf((String)(this.namespace(cluster) + this.setting.toString())) : Configuration.valueOf((String)(this.namespace(cluster) + this.setting + "." + this.name));
            }
        }
        throw new AssertionError(this.operation);
    }

    private String namespace(Cluster cluster) {
        switch (this.getApplicability().getLevel()) {
            case CLUSTER: {
                return "";
            }
            case STRIPE: {
                int stripeId = this.getApplicability().getStripe(cluster).map(stripe -> cluster.getStripeId(stripe.getUID()).orElseThrow(() -> new IllegalArgumentException("Stripe UID: " + stripe.getUID() + " not found in cluster: " + cluster.toShapeString()))).orElseThrow(() -> new IllegalArgumentException("Stripe not found in cluster: " + cluster.toShapeString() + " with applicability: " + this.getApplicability()));
                return "stripe." + stripeId + ".";
            }
            case NODE: {
                int stripeId = this.getApplicability().getStripe(cluster).map(stripe -> cluster.getStripeId(stripe.getUID()).orElseThrow(() -> new IllegalArgumentException("Stripe UID: " + stripe.getUID() + " not found in cluster: " + cluster.toShapeString()))).orElseThrow(() -> new IllegalArgumentException("Stripe not found in cluster: " + cluster.toShapeString() + " with applicability: " + this.getApplicability()));
                int nodeId = this.getApplicability().getNode(cluster).map(node -> this.getNodeId(cluster, node.getUID())).orElseThrow(() -> new IllegalArgumentException("Node not found in cluster: " + cluster.toShapeString() + " with applicability: " + this.getApplicability()));
                return "stripe." + stripeId + ".node." + nodeId + ".";
            }
        }
        throw new AssertionError(this.getApplicability().getLevel());
    }

    public static SettingNomadChange set(Applicability applicability, Setting type, String name, String value) {
        return new SettingNomadChange(applicability, Operation.SET, type, name, value);
    }

    public static SettingNomadChange unset(Applicability applicability, Setting type, String name) {
        return new SettingNomadChange(applicability, Operation.UNSET, type, name, null);
    }

    public static SettingNomadChange set(Applicability applicability, Setting type, String value) {
        return new SettingNomadChange(applicability, Operation.SET, type, null, value);
    }

    public static SettingNomadChange unset(Applicability applicability, Setting type) {
        return new SettingNomadChange(applicability, Operation.UNSET, type, null, null);
    }

    public static SettingNomadChange fromConfiguration(Configuration configuration, Operation operation, Cluster cluster) {
        Applicability applicability = SettingNomadChange.toApplicability(configuration, cluster);
        switch (operation) {
            case SET: {
                return SettingNomadChange.set(applicability, configuration.getSetting(), configuration.getKey(), (String)configuration.getValue().get());
            }
            case UNSET: {
                return SettingNomadChange.unset(applicability, configuration.getSetting(), configuration.getKey());
            }
        }
        throw new IllegalArgumentException("Operation " + operation + " cannot be converted to a Nomad change for an active cluster");
    }

    private static Applicability toApplicability(Configuration configuration, Cluster cluster) {
        switch (configuration.getLevel()) {
            case NODE: {
                return Applicability.node(((Node)cluster.getStripe(configuration.getStripeId()).flatMap(stripe -> SettingNomadChange.getNode(stripe, configuration.getNodeId())).get()).getUID());
            }
            case STRIPE: {
                return Applicability.stripe(((Stripe)cluster.getStripe(configuration.getStripeId()).get()).getUID());
            }
            case CLUSTER: {
                return Applicability.cluster();
            }
        }
        throw new AssertionError(configuration.getLevel());
    }

    private static Optional<Node> getNode(Stripe stripe, int nodeId) {
        if (nodeId < 1) {
            throw new IllegalArgumentException("Invalid node ID: " + nodeId);
        }
        if (nodeId > stripe.getNodeCount()) {
            return Optional.empty();
        }
        return Optional.of(stripe.getNodes().get(nodeId - 1));
    }

    public int getNodeId(Cluster cluster, UID nodeUID) {
        for (Stripe stripe : cluster.getStripes()) {
            List nodes = stripe.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                if (!((Node)nodes.get(i)).getUID().equals((Object)nodeUID)) continue;
                return i + 1;
            }
        }
        throw new IllegalArgumentException("Node UID: " + nodeUID + " not found in cluster: " + cluster.toShapeString());
    }
}

