/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import java.util.Objects;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.NodeNomadChange;

public class NodeRemovalNomadChange
extends NodeNomadChange {
    public NodeRemovalNomadChange(Cluster cluster, UID stripeUID, Node node) {
        super(cluster, stripeUID, node);
    }

    @Override
    public Cluster apply(Cluster original) {
        Objects.requireNonNull(original);
        if (!original.containsNode(this.getNode().getName())) {
            throw new IllegalArgumentException("Node name: " + this.getNode().getName() + " is not in cluster: " + original);
        }
        if (!original.containsNode(this.getNode().getUID())) {
            throw new IllegalArgumentException("Node: " + this.getNode().getUID() + " is not in cluster: " + original);
        }
        Cluster updated = original.clone();
        updated.removeNode(this.getNode().getUID());
        return updated;
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext currentNode) {
        return true;
    }

    public String getSummary() {
        return "Detaching node: " + this.getNode().getName() + " from stripe: " + ((Stripe)this.getCluster().getStripe(this.getStripeUID()).get()).getName();
    }

    public String toString() {
        return "NodeRemovalNomadChange{removedNode=" + this.getNode().getName() + ", cluster=" + this.getCluster().toShapeString() + '}';
    }
}

