/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.nomad.DynamicConfigNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.SettingNomadChange;
import org.terracotta.nomad.client.change.NomadChange;

public class MultiSettingNomadChange
implements DynamicConfigNomadChange {
    private final List<SettingNomadChange> changes;

    public MultiSettingNomadChange(List<SettingNomadChange> changes) {
        this.changes = new ArrayList<SettingNomadChange>((Collection)Objects.requireNonNull(changes));
    }

    public MultiSettingNomadChange(SettingNomadChange ... changes) {
        this(Arrays.asList(changes));
    }

    public List<SettingNomadChange> getChanges() {
        return this.changes;
    }

    public String getSummary() {
        return this.changes.stream().map(NomadChange::getSummary).collect(Collectors.joining(" then "));
    }

    @Override
    public Cluster apply(Cluster original) {
        for (DynamicConfigNomadChange dynamicConfigNomadChange : this.changes) {
            original = dynamicConfigNomadChange.apply(original);
        }
        return original;
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext currentNode) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiSettingNomadChange)) {
            return false;
        }
        MultiSettingNomadChange that = (MultiSettingNomadChange)o;
        return this.getChanges().equals(that.getChanges());
    }

    public int hashCode() {
        return Objects.hash(this.getChanges());
    }

    public String toString() {
        return this.getSummary();
    }

    public static List<? extends DynamicConfigNomadChange> extractChanges(DynamicConfigNomadChange change) {
        return change instanceof MultiSettingNomadChange ? ((MultiSettingNomadChange)change).getChanges() : Collections.singletonList(change);
    }
}

