/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.LockContext;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.nomad.Applicability;
import org.terracotta.dynamic_config.api.model.nomad.FilteredNomadChange;

public class LockConfigNomadChange
extends FilteredNomadChange {
    private final LockContext lockContext;

    public LockConfigNomadChange(LockContext lockContext) {
        super(Applicability.cluster());
        this.lockContext = lockContext;
    }

    @Override
    public Cluster apply(Cluster original) {
        Cluster updated = original.clone();
        updated.setConfigurationLockContext(this.lockContext);
        return updated;
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext nodeContext) {
        return true;
    }

    public String getSummary() {
        return String.format("Locking the config by '%s'", this.lockContext.ownerInfo());
    }

    public LockContext getLockContext() {
        return this.lockContext;
    }
}

