/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Collections;
import java.util.List;
import org.terracotta.dynamic_config.api.json.ApplicabilityV1;
import org.terracotta.dynamic_config.api.json.DynamicConfigModelJsonModule;
import org.terracotta.dynamic_config.api.json.DynamicConfigModelJsonModuleV1;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.Applicability;
import org.terracotta.dynamic_config.api.model.nomad.DefaultApplicability;
import org.terracotta.dynamic_config.api.model.nomad.NodeAdditionNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.NodeRemovalNomadChange;
import org.terracotta.dynamic_config.api.service.FormatUpgrade;

@Deprecated
public class DynamicConfigApiJsonModuleV1
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public DynamicConfigApiJsonModuleV1() {
        super(DynamicConfigApiJsonModuleV1.class.getSimpleName(), new Version(1, 0, 0, null, null, null));
        this.addAbstractTypeMapping(Applicability.class, ApplicabilityV1.class);
        this.registerSubtypes(new NamedType[]{new NamedType(NodeAdditionNomadChangeV1.class, "NodeAdditionNomadChange"), new NamedType(NodeRemovalNomadChangeV1.class, "NodeRemovalNomadChange")});
        this.setMixInAnnotation(Cluster.class, ClusterMixin.class);
        this.setMixInAnnotation(ApplicabilityV1.class, ApplicabilityMixin.class);
        this.setMixInAnnotation(DefaultApplicability.class, DefaultApplicabilityMixin.class);
    }

    public Iterable<? extends Module> getDependencies() {
        return Collections.singletonList(new DynamicConfigModelJsonModuleV1());
    }

    public static class NodeRemovalNomadChangeV1
    extends NodeRemovalNomadChange {
        private final Cluster clusterV1;
        private final int stripeId;
        private final Node nodeV1;

        @JsonCreator
        public NodeRemovalNomadChangeV1(@JsonProperty(value="cluster", required=true) Cluster cluster, @JsonProperty(value="stripeId", required=true) int stripeId, @JsonProperty(value="node", required=true) Node node) {
            super(NodeRemovalNomadChangeV1.upgrade(cluster), ((Stripe)NodeRemovalNomadChangeV1.upgrade(cluster).getStripe(stripeId).get()).getUID(), node);
            this.clusterV1 = cluster;
            this.stripeId = stripeId;
            this.nodeV1 = node;
        }

        public int getStripeId() {
            return this.stripeId;
        }

        @Override
        @JsonIgnore
        public Cluster getCluster() {
            return super.getCluster();
        }

        @Override
        @JsonIgnore
        public UID getStripeUID() {
            return super.getStripeUID();
        }

        @JsonProperty(value="cluster")
        public Cluster getClusterV1() {
            return this.clusterV1;
        }

        @JsonProperty(value="node")
        public Node getNodeV1() {
            return this.nodeV1;
        }

        private static Cluster upgrade(Cluster cluster) {
            return new FormatUpgrade().upgrade(cluster, org.terracotta.dynamic_config.api.model.Version.V1);
        }
    }

    public static class NodeAdditionNomadChangeV1
    extends NodeAdditionNomadChange {
        private final Cluster clusterV1;
        private final int stripeId;
        private final Node nodeV1;

        @JsonCreator
        public NodeAdditionNomadChangeV1(@JsonProperty(value="cluster", required=true) Cluster cluster, @JsonProperty(value="stripeId", required=true) int stripeId, @JsonProperty(value="node", required=true) Node node) {
            super(NodeAdditionNomadChangeV1.upgrade(cluster), ((Stripe)NodeAdditionNomadChangeV1.upgrade(cluster).getStripe(stripeId).get()).getUID(), (Node)NodeAdditionNomadChangeV1.upgrade(cluster).getNodeByName(node.getName()).get());
            this.clusterV1 = cluster;
            this.stripeId = stripeId;
            this.nodeV1 = node;
        }

        public int getStripeId() {
            return this.stripeId;
        }

        @Override
        @JsonIgnore
        public Cluster getCluster() {
            return super.getCluster();
        }

        @Override
        @JsonIgnore
        public UID getStripeUID() {
            return super.getStripeUID();
        }

        @JsonProperty(value="cluster")
        public Cluster getClusterV1() {
            return this.clusterV1;
        }

        @JsonProperty(value="node")
        public Node getNodeV1() {
            return this.nodeV1;
        }

        private static Cluster upgrade(Cluster cluster) {
            return new FormatUpgrade().upgrade(cluster, org.terracotta.dynamic_config.api.model.Version.V1);
        }
    }

    public static abstract class ApplicabilityMixin
    extends ApplicabilityV1 {
        public ApplicabilityMixin(@JsonProperty(value="scope", required=true) Scope scope, @JsonProperty(value="stripeId") Integer stripeId, @JsonProperty(value="nodeName") String nodeName) {
            super(scope, stripeId, nodeName);
        }

        @Override
        @JsonProperty(value="scope")
        public Scope getLevel() {
            return super.getLevel();
        }
    }

    public static class DefaultApplicabilityMixin
    extends DefaultApplicability {
        public DefaultApplicabilityMixin(@JsonProperty(value="level", required=true) Scope level, @JsonProperty(value="stripeUID") UID stripeUID, @JsonProperty(value="nodeUID") UID nodeUID) {
            super(level, stripeUID, nodeUID);
        }

        @Override
        @JsonProperty(value="scope")
        public Scope getLevel() {
            return super.getLevel();
        }
    }

    @JsonPropertyOrder(value={"name", "stripe"}, alphabetic=true)
    public static class ClusterMixin
    extends DynamicConfigModelJsonModule.ClusterMixin {
        @JsonCreator
        protected ClusterMixin(@JsonProperty(value="stripes", required=true) List<Stripe> stripes) {
            super(stripes);
        }
    }
}

