/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.parsing;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.PathConverter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.terracotta.dynamic_config.cli.api.command.Injector;
import org.terracotta.dynamic_config.cli.command.Command;
import org.terracotta.dynamic_config.cli.command.Usage;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.ConversionFormat;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.command.ConvertAction;

@Parameters(commandDescription="Convert tc-config files to configuration directory format")
@Usage(value="-tc-config <tc-config>,<tc-config>... [ -stripe-names <foo>,<bar>,<baz> ]  ( -format directory [-license <license-file>] -new-cluster-name <new-cluster-name> | -format properties [-new-cluster-name <new-cluster-name>]) [-destination <destination-dir>] [-force]")
public class ConvertCommand
extends Command {
    @Parameter(names={"-tc-config"}, required=true, description="An ordered list of tc-config files", converter=PathConverter.class)
    private List<Path> tcConfigFiles;
    @Parameter(names={"-stripe-names"}, required=false, description="An ordered list of stripe names")
    private List<String> stripeNames;
    @Parameter(names={"-license"}, description="Path to license file", converter=PathConverter.class)
    private Path licensePath;
    @Parameter(names={"-destination"}, description="Destination directory to store converted config. Should not exist. Default: ${current-directory}/converted-configs", converter=PathConverter.class)
    private Path destinationDir = Paths.get(".", new String[0]).resolve("converted-configs");
    @Parameter(names={"-new-cluster-name"}, description="New cluster name")
    private String newClusterName;
    @Parameter(names={"-format"}, description="Conversion type (directory|properties). Default: directory", converter=ConversionFormat.FormatConverter.class)
    private ConversionFormat conversionFormat = ConversionFormat.DIRECTORY;
    @Parameter(names={"-force"}, description="Force a config conversion, ignoring warnings, if any")
    private boolean force;
    @Injector.Inject
    public final ConvertAction action;

    public ConvertCommand() {
        this(new ConvertAction());
    }

    public ConvertCommand(ConvertAction action) {
        this.action = action;
    }

    public void run() {
        this.action.setTcConfigFiles(this.tcConfigFiles);
        this.action.setStripeNames(this.stripeNames);
        this.action.setLicensePath(this.licensePath);
        this.action.setDestinationDir(this.destinationDir);
        this.action.setNewClusterName(this.newClusterName);
        this.action.setConversionFormat(this.conversionFormat);
        this.action.setForce(this.force);
        this.action.run();
    }
}

