/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.conversion;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.config.TCConfigurationParser;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.service.NameGenerator;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.ConfigConversionException;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.ErrorCode;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.ErrorParamKey;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.InvalidInputConfigurationContentException;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.InvalidInputException;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.validators.ValidationWrapper;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml.NonSubstitutingTCConfigurationParser;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml.TcConfigMapper;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml.XmlUtility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTcConfigMapper
implements TcConfigMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTcConfigMapper.class);
    private static String NS_DATA_ROOT = "http://www.terracottatech.com/config/data-roots";
    private static String NS_PLATFORM_PERSISTENCE = "http://www.terracottatech.com/config/platform-persistence";
    static final String TERRACOTTA_CONFIG_NAMESPACE = "http://www.terracotta.org/config";
    static final String NAME_NODE_NAME = "name";
    static final String NAME_NODE_HOST = "host";
    static final String PORT_NODE_NAME = "tsa-port";
    static final String SERVERS_NODE_NAME = "servers";
    static final String SERVER_NODE_NAME = "server";
    static final String PLUGINS_NODE_NAME = "plugins";
    static final String PLATFORM_PERSISTENCE_DATA_DIR_ID_ATTR_NAME = "data-directory-id";
    static final String DATA_DIR_USER_FOR_PLATFORM_ATTR_NAME = "use-for-platform";
    static final String NAME_ATTR_NAME = "name";
    private final Map<Path, Node> configFileRootNodeMap = new HashMap<Path, Node>();
    private final List<String> allServers = new ArrayList<String>();
    protected ClassLoader classLoader;

    public abstract Cluster getStripe(String var1);

    @Override
    public void init(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader);
    }

    @Override
    public Cluster parseConfig(String clusterName, List<String> stripeNames, Path ... tcConfigPaths) {
        HashMap<Integer, Path> configFilePerStripeMap = new HashMap<Integer, Path>();
        HashMap<Tuple2<Integer, String>, Node> stripeServerConfigNodeMap = new HashMap<Tuple2<Integer, String>, Node>();
        int stripeId = 1;
        for (Path tcConfigPath : tcConfigPaths) {
            configFilePerStripeMap.put(stripeId++, tcConfigPath);
        }
        for (Map.Entry entry : configFilePerStripeMap.entrySet()) {
            this.createServerConfigMapFunction(stripeServerConfigNodeMap, (Integer)entry.getKey(), (Path)entry.getValue());
        }
        LOGGER.trace("Checking if deprecated platform-persistence needs to be converted to data-directory. Will convert if found.");
        this.handlePlatformPersistence(this.configFileRootNodeMap);
        LOGGER.trace("Validating contents of the configuration files");
        this.valueValidators();
        LOGGER.trace("Building Cluster");
        return this.getCluster(clusterName, stripeServerConfigNodeMap, stripeNames);
    }

    protected void valueValidators() {
        Map<Path, Map<String, Node>> configAndServiceNodesPerConfigFile = this.buildConfigurationFilePluginNodeMap();
        Set<String> namespaces = this.validateAllConfigurationFilesHaveSamePluginTypes(configAndServiceNodesPerConfigFile);
        List<Tuple2<Map<Path, Node>, ValidationWrapper>> validatorsWithParams = this.prepareValidatorsForPluginConfigurations(namespaces, configAndServiceNodesPerConfigFile);
        this.validatePluginConfigurations(validatorsWithParams);
    }

    protected Set<String> validateAllConfigurationFilesHaveSamePluginTypes(Map<Path, Map<String, Node>> configAndServiceNodesPerConfigFile) {
        AtomicReference previousSetReference = new AtomicReference();
        AtomicReference previousPath = new AtomicReference();
        configAndServiceNodesPerConfigFile.forEach((path, nodeMap) -> {
            if (previousSetReference.get() == null) {
                previousSetReference.set(nodeMap.keySet());
                previousPath.set(path);
                return;
            }
            Set currentSet = nodeMap.keySet();
            if (!((Set)previousSetReference.get()).equals(currentSet)) {
                throw new InvalidInputConfigurationContentException(ErrorCode.MISMATCHED_SERVICE_CONFIGURATION, "Mismatched Service Configuration", Tuple2.tuple2((Object)ErrorParamKey.CONFIG_FILE.name(), (Object)path.toString()), Tuple2.tuple2((Object)ErrorParamKey.CONFIG_FILE.name(), (Object)((Path)previousPath.get()).toString()));
            }
            previousSetReference.set(nodeMap.keySet());
        });
        return (Set)previousSetReference.get();
    }

    protected List<Tuple2<Map<Path, Node>, ValidationWrapper>> prepareValidatorsForPluginConfigurations(Set<String> namespaces, Map<Path, Map<String, Node>> configAndServiceNodesPerConfigFile) {
        ArrayList<Tuple2<Map<Path, Node>, ValidationWrapper>> validatorsWithParams = new ArrayList<Tuple2<Map<Path, Node>, ValidationWrapper>>();
        namespaces.forEach(namespace -> {
            HashMap configFilesAndNodesMap = new HashMap();
            configAndServiceNodesPerConfigFile.forEach((path, nodeMap) -> {
                Node node = (Node)nodeMap.get(namespace);
                configFilesAndNodesMap.put(path, node);
            });
            Supplier<ValidationWrapper> validatorSupplier = this.getValidatorSupplier((String)namespace);
            validatorsWithParams.add(Tuple2.tuple2(configFilesAndNodesMap, (Object)validatorSupplier.get()));
        });
        return validatorsWithParams;
    }

    protected void validatePluginConfigurations(List<Tuple2<Map<Path, Node>, ValidationWrapper>> validatorsWithParams) {
        validatorsWithParams.forEach(pair -> ((ValidationWrapper)pair.getT2()).check((Map)pair.getT1()));
    }

    protected Node getRootNode(Path configFilePath) throws Exception {
        File configFile = configFilePath.toFile();
        try (FileInputStream in = new FileInputStream(configFile);){
            Element element = NonSubstitutingTCConfigurationParser.getRootElement(in, this.classLoader);
            return element;
        }
    }

    protected Node getClonedParentDocNode(Node rootNode) {
        return XmlUtility.getClonedParentDocFromRootNode(rootNode);
    }

    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"})
    protected List<String> extractServerNames(Node rootConfigNode) {
        ArrayList<String> serverNames = new ArrayList<String>();
        for (int i = 0; i < rootConfigNode.getChildNodes().getLength(); ++i) {
            Node childNode = rootConfigNode.getChildNodes().item(i);
            if (!TERRACOTTA_CONFIG_NAMESPACE.equals(childNode.getNamespaceURI()) || !SERVERS_NODE_NAME.equals(childNode.getLocalName())) continue;
            for (int j = 0; j < childNode.getChildNodes().getLength(); ++j) {
                Node potentialServerNode = childNode.getChildNodes().item(j);
                if (!TERRACOTTA_CONFIG_NAMESPACE.equals(potentialServerNode.getNamespaceURI()) || !SERVER_NODE_NAME.equals(potentialServerNode.getLocalName())) continue;
                String serverName = this.getAttributeValue(potentialServerNode, "name", false);
                if (serverName == null) {
                    serverName = this.getAttributeValue(potentialServerNode, NAME_NODE_HOST, false);
                    if (serverName == null || serverName.contains("%")) {
                        throw new IllegalStateException("Conversion process requires a valid server name or hostname");
                    }
                    int max = potentialServerNode.getChildNodes().getLength();
                    for (int k = 0; k < max; ++k) {
                        String port;
                        Node child = potentialServerNode.getChildNodes().item(k);
                        if (!TERRACOTTA_CONFIG_NAMESPACE.equals(child.getNamespaceURI()) || !PORT_NODE_NAME.equals(child.getLocalName()) || (port = child.getFirstChild().getNodeValue()) == null || port.trim().isEmpty()) continue;
                        if (port.contains("%")) {
                            throw new IllegalStateException("Conversion process requires a valid server port");
                        }
                        serverName = serverName + ":" + port.trim();
                        break;
                    }
                }
                serverNames.add(serverName);
            }
        }
        return serverNames;
    }

    protected String getAttributeValue(Node node, String attributeName, boolean throwException) {
        Optional<String> attributeValue = this.getOptionalAttributeValue(node, attributeName);
        if (attributeValue.isPresent()) {
            return attributeValue.get();
        }
        if (throwException) {
            throw new ConfigConversionException(ErrorCode.INVALID_ATTRIBUTE_NAME, "Attribute " + attributeName + " is missing in Node " + node.getLocalName(), Tuple2.tuple2((Object)"AttributeName", (Object)attributeName), Tuple2.tuple2((Object)"nodeName", (Object)node.getLocalName()));
        }
        return null;
    }

    protected String getAttributeValue(Node node, String attributeName) {
        return this.getAttributeValue(node, attributeName, true);
    }

    protected void setAttributeValue(Node node, String attributeName, String attributeValue) {
        XmlUtility.setAttribute(node, attributeName, attributeValue);
    }

    protected void removeNode(Node node, boolean removeEmptyParent) {
        XmlUtility.removeNode(node, removeEmptyParent);
    }

    protected Optional<String> getOptionalAttributeValue(Node node, String attributeName) {
        return XmlUtility.getAttributeValue(node, attributeName);
    }

    protected Map<Path, Map<String, Node>> buildConfigurationFilePluginNodeMap() {
        HashMap<Path, Map<String, Node>> configAndServiceNodesPerConfigFile = new HashMap<Path, Map<String, Node>>();
        this.configFileRootNodeMap.forEach((configFile, rootNode) -> {
            HashMap<String, Node> uriServiceConfigNodeMap = new HashMap<String, Node>();
            for (int i = 0; i < rootNode.getChildNodes().getLength(); ++i) {
                Node node = rootNode.getChildNodes().item(i);
                if (!PLUGINS_NODE_NAME.equals(node.getLocalName())) continue;
                NodeList nodeList = node.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node configNode = nodeList.item(j);
                    if (configNode.getChildNodes().getLength() <= 0) continue;
                    Node configServiceNode = configNode.getChildNodes().item(0);
                    String uri = configServiceNode.getNamespaceURI();
                    if (uriServiceConfigNodeMap.containsKey(uri)) {
                        throw new InvalidInputException(ErrorCode.SAME_SERVICE_DEFINED_MULTIPLE_TIMES, "URI" + uri + " has multiple service configuration", Tuple2.tuple2((Object)ErrorParamKey.URI.name(), (Object)uri));
                    }
                    uriServiceConfigNodeMap.put(configServiceNode.getNamespaceURI(), configServiceNode);
                }
            }
            configAndServiceNodesPerConfigFile.put((Path)configFile, (Map<String, Node>)uriServiceConfigNodeMap);
        });
        return configAndServiceNodesPerConfigFile;
    }

    protected Supplier<ValidationWrapper> getValidatorSupplier(String namespace) {
        return () -> new ValidationWrapper(TCConfigurationParser.getValidator((URI)URI.create(namespace)));
    }

    protected void createServerConfigMapFunction(Map<Tuple2<Integer, String>, Node> stripeServerConfigMapNode, int stripeId, Path configFilePath) {
        try {
            if (!this.regularFile(configFilePath)) {
                throw new InvalidInputException(ErrorCode.INVALID_FILE_TYPE, "Provided file " + configFilePath.toString() + " is not a regular file", Tuple2.tuple2((Object)ErrorParamKey.INVALID_FILE_TYPE.name(), (Object)configFilePath.toString()));
            }
            Node element = this.getRootNode(configFilePath);
            this.configFileRootNodeMap.put(configFilePath, element);
            List<String> serverNames = this.extractServerNames(element);
            this.checkUniqueServerNamesInStripe(serverNames, stripeId, configFilePath);
            this.allServers.addAll(serverNames);
            serverNames.forEach(s -> stripeServerConfigMapNode.put(Tuple2.tuple2((Object)stripeId, (Object)s), this.getClonedParentDocNode(element)));
        }
        catch (ConfigConversionException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Unexpected error while migrating the configuration files: " + e.getMessage();
            LOGGER.debug(errorMessage, (Throwable)e);
            throw new ConfigConversionException(ErrorCode.UNKNOWN_ERROR, errorMessage, new Tuple2[0]);
        }
    }

    protected void handlePlatformPersistence(Map<Path, Node> configurationFileFileRootNodeMap) {
        configurationFileFileRootNodeMap.forEach(this.handlePlatformPersistencePerConfigurationFile());
    }

    protected BiConsumer<Path, Node> handlePlatformPersistencePerConfigurationFile() {
        return (configFilePath, rootNode) -> {
            Node dataRootNode = null;
            Node platformPersistenceNode = null;
            for (int i = 0; i < rootNode.getChildNodes().getLength(); ++i) {
                Node node = rootNode.getChildNodes().item(i);
                if (!PLUGINS_NODE_NAME.equals(node.getLocalName())) continue;
                NodeList nodeList = node.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node configNode = nodeList.item(j);
                    if (configNode.getChildNodes().getLength() <= 0) continue;
                    Node configServiceNode = configNode.getChildNodes().item(0);
                    String uri = configServiceNode.getNamespaceURI();
                    if (NS_DATA_ROOT.equals(uri)) {
                        dataRootNode = configServiceNode;
                        continue;
                    }
                    if (!NS_PLATFORM_PERSISTENCE.equals(uri)) continue;
                    platformPersistenceNode = configServiceNode;
                }
            }
            this.remapPlatformPersistence(dataRootNode, platformPersistenceNode, (Path)configFilePath);
        };
    }

    protected void remapPlatformPersistence(Node dataRootNode, Node platformPersistenceNode, Path configFilePath) {
        if (platformPersistenceNode != null) {
            if (dataRootNode == null || dataRootNode.getChildNodes().getLength() == 0) {
                throw new InvalidInputConfigurationContentException(ErrorCode.NO_DATA_DIR_WITH_PLATFORM_PERSISTENCE, "Platform persistence points to a data-directory which is not present in the configuration file", Tuple2.tuple2((Object)ErrorParamKey.CONFIG_FILE.name(), (Object)configFilePath.toString()));
            }
            String dataDirId = this.getAttributeValue(platformPersistenceNode, PLATFORM_PERSISTENCE_DATA_DIR_ID_ATTR_NAME);
            NodeList dataDirectories = dataRootNode.getChildNodes();
            boolean dataDirMatched = false;
            for (int i = 0; i < dataDirectories.getLength(); ++i) {
                Node currentDataRootNode = dataDirectories.item(i);
                String dataRootName = this.getAttributeValue(currentDataRootNode, "name");
                if (!dataDirId.equals(dataRootName)) continue;
                String useForPlatformString = this.getAttributeValue(currentDataRootNode, DATA_DIR_USER_FOR_PLATFORM_ATTR_NAME, false);
                boolean useForPlatform = Boolean.parseBoolean(useForPlatformString);
                if (!useForPlatform) {
                    this.setAttributeValue(currentDataRootNode, DATA_DIR_USER_FOR_PLATFORM_ATTR_NAME, Boolean.TRUE.toString());
                }
                dataDirMatched = true;
                break;
            }
            if (!dataDirMatched) {
                throw new InvalidInputConfigurationContentException(ErrorCode.INVALID_DATA_DIR_FOR_PLATFORM_PERSISTENCE, "Name for the data-directory missing", Tuple2.tuple2((Object)ErrorParamKey.CONFIG_FILE.name(), (Object)configFilePath.toString()));
            }
            this.removeNode(platformPersistenceNode, true);
        }
    }

    protected void checkUniqueServerNamesInStripe(List<String> serverNames, int stripeId, Path configFilePath) {
        Collection duplicates = serverNames.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toCollection(TreeSet::new));
        if (!duplicates.isEmpty()) {
            throw new InvalidInputConfigurationContentException(ErrorCode.DUPLICATE_SERVER_NAME_IN_STRIPE, String.format("Duplicate server names %s in configuration file %s for stripe %s", String.join((CharSequence)",", duplicates), configFilePath, stripeId), new Tuple2[0]);
        }
    }

    protected void validateProvidedConfiguration(Map<Tuple2<Integer, String>, Node> hostConfigMapNode, List<String> allServers) {
        List<String> serversInAllStripesAsInput = hostConfigMapNode.keySet().stream().map(Tuple2::getT2).collect(Collectors.toList());
        if (serversInAllStripesAsInput.size() != allServers.size()) {
            Tuple2[] servers = (Tuple2[])Array.newInstance(Tuple2.class, serversInAllStripesAsInput.size() + allServers.size());
            AtomicInteger counter = new AtomicInteger(0);
            serversInAllStripesAsInput.forEach(serverInInput -> {
                servers[counter.getAndIncrement()] = Tuple2.tuple2((Object)ErrorParamKey.SERVERS_IN_COMMAND.name(), (Object)serverInInput);
            });
            allServers.forEach(server -> {
                servers[counter.getAndIncrement()] = Tuple2.tuple2((Object)ErrorParamKey.SERVERS_IN_CONFIG_FILES.name(), (Object)server);
            });
            throw new InvalidInputException(ErrorCode.MISSING_SERVERS, String.format("Not all servers are provided. Servers provided as input are: %s, whereas servers present in configuration files are: %s ", String.join((CharSequence)",", serversInAllStripesAsInput), String.join((CharSequence)",", allServers)), servers);
        }
        Collection<String> mismatched = this.mismatchedServers(hostConfigMapNode, allServers);
        if (mismatched.size() > 0) {
            String mismatchedString = String.join((CharSequence)",", mismatched);
            throw new InvalidInputException(ErrorCode.MISMATCHED_SERVERS, "Mismatched servers are : " + mismatchedString, Tuple2.tuple2((Object)ErrorParamKey.MISMATCHED_SERVERS.name(), (Object)mismatchedString));
        }
    }

    protected Collection<String> mismatchedServers(Map<Tuple2<Integer, String>, Node> hostConfigMapNode, List<String> allServers) {
        return hostConfigMapNode.keySet().stream().map(pair -> {
            String serverName = (String)pair.getT2();
            return !allServers.contains(serverName) ? serverName : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected boolean regularFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    protected Cluster getCluster(String clusterName, Map<Tuple2<Integer, String>, Node> nodeNameNodeConfigMap, List<String> stripeNames) {
        void var7_11;
        this.validateProvidedConfiguration(nodeNameNodeConfigMap, this.allServers);
        HashMap<Object, Node> oneConfigPerStripe = new HashMap<Object, Node>();
        for (Map.Entry<Tuple2<Integer, String>, Node> entry : nodeNameNodeConfigMap.entrySet()) {
            if (oneConfigPerStripe.containsKey(entry.getKey().t1)) continue;
            oneConfigPerStripe.put(entry.getKey().t1, entry.getValue());
        }
        ArrayList<Cluster> stripes = new ArrayList<Cluster>();
        for (Map.Entry entry : oneConfigPerStripe.entrySet()) {
            Node doc = (Node)entry.getValue();
            try {
                String xml = XmlUtility.getPrettyPrintableXmlString(doc);
                Cluster stripe2 = this.getStripe(xml);
                stripes.add(stripe2);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
        }
        Cluster cluster = ((Cluster)stripes.stream().reduce((result, stripe) -> result.addStripe(((Stripe)stripe.getSingleStripe().get()).clone())).orElseThrow(() -> new RuntimeException("No server specified."))).setName(clusterName);
        cluster.setUID(cluster.newUID());
        cluster.getStripes().forEach(stripe -> {
            stripe.setUID(cluster.newUID());
            stripe.getNodes().forEach(node -> node.setUID(cluster.newUID()));
        });
        boolean bl = false;
        int max = Math.min(cluster.getStripeCount(), stripeNames.size());
        while (var7_11 < max) {
            ((Stripe)cluster.getStripes().get((int)var7_11)).setName(stripeNames.get((int)var7_11));
            ++var7_11;
        }
        NameGenerator.assignFriendlyNames((Cluster)cluster);
        return cluster;
    }
}

