/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.converter;

import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.IParameterSplitter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.cli.api.command.ConfigurationInput;

public class MultiConfigCommaSplitter
implements IParameterSplitter {
    public List<String> split(String value) {
        String[] keyValue = value.split("=", 2);
        if (keyValue.length != 2) {
            return Collections.singletonList(value);
        }
        if (!this.isMap(keyValue[0])) {
            return Collections.singletonList(value);
        }
        if (this.hasKey(keyValue[0])) {
            return Collections.singletonList(value);
        }
        return Stream.of(keyValue[1].split(",")).filter(s -> !s.trim().isEmpty()).map(s -> {
            String[] nameProperty = s.trim().split(":", 2);
            if (nameProperty.length != 2) {
                throw new ParameterException("Invalid input: " + value);
            }
            return keyValue[0] + "." + nameProperty[0] + "=" + nameProperty[1];
        }).distinct().collect(Collectors.toList());
    }

    private boolean isMap(String key) {
        try {
            return ConfigurationInput.getSetting((String)key).isMap();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasKey(String key) {
        try {
            return ConfigurationInput.getKey((String)key) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

