/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.command;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.internal.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.terracotta.dynamic_config.cli.command.Command;
import org.terracotta.dynamic_config.cli.command.Usage;

public class CustomJCommander<M extends Command>
extends JCommander {
    private final M mainCommand;
    private final Map<String, Command> commands;
    private final String toolName;

    public CustomJCommander(String toolName, Map<String, Command> commands, M mainCommand) {
        super(mainCommand);
        this.toolName = toolName;
        this.mainCommand = mainCommand;
        this.commands = commands;
        this.setUsageFormatter(new UsageFormatter(this));
        commands.forEach((arg_0, arg_1) -> ((CustomJCommander)this).addCommand(arg_0, arg_1));
    }

    public Optional<Command> getAskedCommand() {
        return Optional.ofNullable(this.getParsedCommand()).map(this.commands::get);
    }

    public void printUsage() {
        String askedCommand = this.getParsedCommand();
        if (askedCommand != null) {
            this.printAskedCommandUsage(askedCommand);
        } else {
            this.usage();
        }
    }

    public void printAskedCommandUsage(String askedCommand) {
        this.getUsageFormatter().usage(askedCommand);
    }

    public Map<String, JCommander> getCommands() {
        return new TreeMap<String, JCommander>(super.getCommands());
    }

    protected void appendDefinitions(StringBuilder out, String indent) {
    }

    public M getMainCommand() {
        return this.mainCommand;
    }

    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"})
    private static String pad(String str, int colSize) {
        while (str.length() < colSize) {
            str = str + " ";
        }
        return str;
    }

    public static String getUsage(Command command) {
        Usage annotation = command.getClass().getAnnotation(Usage.class);
        if (annotation != null) {
            return annotation.value();
        }
        return "";
    }

    private class UsageFormatter
    implements IUsageFormatter {
        private final JCommander commander;

        public UsageFormatter(JCommander commander) {
            this.commander = commander;
        }

        public void usage(String commandName) {
            StringBuilder sb = new StringBuilder();
            this.usage(commandName, sb);
            this.commander.getConsole().println(sb.toString());
        }

        public void usage(String commandName, StringBuilder out) {
            this.usage(commandName, out, "");
        }

        public void usage(StringBuilder out) {
            this.usage(out, "");
        }

        public void usage(String commandName, StringBuilder out, String indent) {
            String description = this.getCommandDescription(commandName);
            JCommander jc = CustomJCommander.this.getCommands().get(commandName);
            if (description != null) {
                out.append(indent).append(description).append(System.lineSeparator());
            }
            this.appendUsage(commandName, (Command)CustomJCommander.this.commands.get(commandName), out, indent);
            this.appendOptions(jc, out, indent);
        }

        public void usage(StringBuilder out, String indent) {
            Map<String, JCommander> commands = CustomJCommander.this.getCommands();
            boolean hasCommands = !commands.isEmpty();
            out.append(indent).append("Usage: ").append(CustomJCommander.this.toolName).append(" [options]");
            if (hasCommands) {
                out.append(indent).append(" [command] [command options]");
            }
            out.append(System.lineSeparator()).append(System.lineSeparator());
            this.appendOptions(this.commander, out, indent);
            CustomJCommander.this.appendDefinitions(out, indent);
            this.appendCommands(out, indent, commands, hasCommands);
        }

        public String getCommandDescription(String commandName) {
            return new DefaultUsageFormatter(this.commander).getCommandDescription(commandName);
        }

        private void appendCommands(StringBuilder out, String indent, Map<String, JCommander> jcommanders, boolean hasCommands) {
            if (hasCommands) {
                out.append(System.lineSeparator()).append("Commands:").append(System.lineSeparator()).append(System.lineSeparator());
                for (Map.Entry<String, JCommander> command : jcommanders.entrySet()) {
                    String name = command.getKey();
                    Object arg = command.getValue().getObjects().get(0);
                    Parameters p = arg.getClass().getAnnotation(Parameters.class);
                    if (p != null && p.hidden()) continue;
                    String description = this.getCommandDescription(name);
                    out.append(System.lineSeparator());
                    out.append(indent).append("    ").append(name).append("      ").append(description).append(System.lineSeparator()).append(System.lineSeparator());
                    this.appendUsage(name, (Command)CustomJCommander.this.commands.get(name), out, indent + "        ");
                    out.append(System.lineSeparator());
                    JCommander jc = command.getValue();
                    this.appendOptions(jc, out, "        ");
                }
            }
        }

        private void appendUsage(String name, Command command, StringBuilder out, String indent) {
            out.append(indent).append("Usage: ");
            String usage = name + " " + CustomJCommander.getUsage(command);
            out.append(usage.replace(System.lineSeparator(), System.lineSeparator() + "    " + indent)).append(System.lineSeparator());
        }

        private void appendOptions(JCommander jCommander, StringBuilder out, String indent) {
            List sorted = Lists.newArrayList();
            int colSize = "-security-root-directory".length();
            for (ParameterDescription pd2 : jCommander.getParameters()) {
                if (pd2.getParameter().hidden()) continue;
                sorted.add(pd2);
                int length = pd2.getParameterAnnotation().names()[0].length();
                if (length <= colSize) continue;
                colSize = length;
            }
            if (sorted.size() > 0) {
                sorted.sort(Comparator.comparing(pd -> pd.getParameterAnnotation().names()[0]));
                out.append(indent).append("Options:").append(System.lineSeparator());
                for (ParameterDescription pd2 : sorted) {
                    WrappedParameter parameter = pd2.getParameter();
                    out.append(indent).append("    ").append(CustomJCommander.pad(pd2.getParameterAnnotation().names()[0], colSize)).append(parameter.required() ? " (required)    " : " (optional)    ").append(pd2.getDescription()).append(System.lineSeparator());
                }
            }
        }
    }
}

