/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.cli.api.command.ConfigurationMutationAction;

public class SetAction
extends ConfigurationMutationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetAction.class);

    public SetAction() {
        super(Operation.SET);
    }

    @Override
    protected void validate() {
        super.validate();
        List configs = this.configurations.stream().filter(configuration -> configuration.getSetting() == Setting.LICENSE_FILE).collect(Collectors.toList());
        this.configurations.removeIf(cfg -> cfg.getSetting() == Setting.LICENSE_FILE);
        if (!configs.isEmpty()) {
            Configuration configuration2 = (Configuration)configs.get(configs.size() - 1);
            Path licenseFile = configuration2.getValue().map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new IllegalArgumentException("Missing value for setting license-file in set command"));
            if (!licenseFile.toFile().exists()) {
                throw new IllegalArgumentException("License file not found: " + licenseFile);
            }
            Collection<Node.Endpoint> peers = this.findRuntimePeers(this.node);
            LOGGER.debug("Installing license: {} on nodes: {}", (Object)licenseFile, (Object)SetAction.toString(peers));
            this.upgradeLicense(peers, licenseFile);
            this.output.info("License installation successful.", new Object[0]);
        }
    }
}

