/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.diagnostic.model.LogicalServerState;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.service.ConfigurationConsistencyAnalyzer;
import org.terracotta.dynamic_config.api.service.ConfigurationConsistencyState;
import org.terracotta.dynamic_config.cli.api.command.RemoteAction;
import org.terracotta.dynamic_config.cli.api.converter.RepairMethod;
import org.terracotta.inet.HostPort;
import org.terracotta.nomad.server.ChangeRequestState;

public class RepairAction
extends RemoteAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepairAction.class);
    private HostPort node;
    private RepairMethod forcedRepairMethod;

    public void setNode(HostPort node) {
        this.node = node;
    }

    public void setForcedRepairAction(RepairMethod forcedRepairMethod) {
        this.forcedRepairMethod = forcedRepairMethod;
    }

    @Override
    public final void run() {
        if (this.forcedRepairMethod == RepairMethod.RESET) {
            this.resetAndStop(this.node);
        } else if (this.forcedRepairMethod == RepairMethod.UNLOCK) {
            this.forceUnlock();
        } else {
            this.nomadRepair();
        }
        this.output.info("Command successful!", new Object[0]);
    }

    private void forceUnlock() {
        Map<Node.Endpoint, LogicalServerState> allNodes = this.findRuntimePeersStatus(this.node);
        LinkedHashMap<Node.Endpoint, LogicalServerState> onlineNodes = this.filterOnlineNodes(allNodes);
        if (onlineNodes.size() != allNodes.size()) {
            ArrayList<Node.Endpoint> offlines = new ArrayList<Node.Endpoint>(allNodes.keySet());
            offlines.removeAll(onlineNodes.keySet());
            LOGGER.warn("Some nodes are not reachable: {}", (Object)RepairAction.toString(offlines));
        }
        Cluster cluster = this.getUpcomingCluster(this.node);
        this.forceUnlock(cluster, onlineNodes);
    }

    private void nomadRepair() {
        LinkedHashMap<Node.Endpoint, LogicalServerState> activatedNodes;
        Map<Node.Endpoint, LogicalServerState> allNodes = this.findRuntimePeersStatus(this.node);
        LinkedHashMap<Node.Endpoint, LogicalServerState> onlineNodes = this.filterOnlineNodes(allNodes);
        if (onlineNodes.size() != allNodes.size()) {
            ArrayList<Node.Endpoint> offlines = new ArrayList<Node.Endpoint>(allNodes.keySet());
            offlines.removeAll(onlineNodes.keySet());
            LOGGER.warn("Some nodes are not reachable: {}", (Object)RepairAction.toString(offlines));
        }
        if ((activatedNodes = this.filter(onlineNodes, (endpoint, state) -> this.isActivated((Node.Endpoint)endpoint))).isEmpty()) {
            throw new IllegalStateException("No activated node found. Repair command only works with activated nodes.");
        }
        if (activatedNodes.size() != onlineNodes.size()) {
            ArrayList unconfigured = new ArrayList(onlineNodes.keySet());
            unconfigured.removeAll(activatedNodes.keySet());
            LOGGER.warn("Some online nodes are not activated: {}. Automatic repair will only work against activated nodes: {}", (Object)RepairAction.toString(unconfigured), (Object)RepairAction.toString(activatedNodes.keySet()));
        }
        ConfigurationConsistencyAnalyzer configurationConsistencyAnalyzer = this.analyzeNomadConsistency(allNodes);
        ConfigurationConsistencyState state2 = configurationConsistencyAnalyzer.getState();
        String description = configurationConsistencyAnalyzer.getDescription();
        switch (state2) {
            case ALL_ACCEPTING: 
            case ONLINE_ACCEPTING: {
                LOGGER.info(description);
                break;
            }
            case DISCOVERY_FAILURE: {
                LOGGER.error(description, (Throwable)configurationConsistencyAnalyzer.getDiscoverFailure().get());
                break;
            }
            case INCONSISTENT: 
            case PARTITIONED: 
            case CHANGE_IN_PROGRESS: 
            case UNKNOWN: {
                LOGGER.error(description);
                break;
            }
            case ALL_PREPARED: {
                this.repair(allNodes, configurationConsistencyAnalyzer, RepairMethod.COMMIT);
                break;
            }
            case ONLINE_PREPARED: {
                this.repair(allNodes, configurationConsistencyAnalyzer, null);
                break;
            }
            case PARTIALLY_PREPARED: {
                if (this.forcedRepairMethod != RepairMethod.ROLLBACK) {
                    throw new IllegalArgumentException("The configuration is partially prepared. A rollback is needed. A " + (Object)((Object)this.forcedRepairMethod) + " cannot be executed.");
                }
                this.repair(allNodes, configurationConsistencyAnalyzer, RepairMethod.ROLLBACK);
                break;
            }
            case PARTIALLY_COMMITTED: {
                if (this.forcedRepairMethod != RepairMethod.COMMIT) {
                    throw new IllegalArgumentException("The configuration is partially committed. A commit is needed. A " + (Object)((Object)this.forcedRepairMethod) + " cannot be executed.");
                }
                this.repair(allNodes, configurationConsistencyAnalyzer, RepairMethod.COMMIT);
                break;
            }
            case PARTIALLY_ROLLED_BACK: {
                if (this.forcedRepairMethod != RepairMethod.ROLLBACK) {
                    throw new IllegalArgumentException("The configuration is partially rolled back. A rollback is needed. A " + (Object)((Object)this.forcedRepairMethod) + " cannot be executed.");
                }
                this.repair(allNodes, configurationConsistencyAnalyzer, RepairMethod.ROLLBACK);
                break;
            }
            default: {
                throw new AssertionError(state2);
            }
        }
    }

    private void repair(Map<Node.Endpoint, LogicalServerState> allNodes, ConfigurationConsistencyAnalyzer configurationConsistencyAnalyzer, RepairMethod fallbackRepairMethod) {
        RepairMethod wanted;
        Set onlineActivatedAddresses = configurationConsistencyAnalyzer.getOnlineNodesActivated().keySet();
        Map<Node.Endpoint, LogicalServerState> onlineActivatedEndpoints = allNodes.entrySet().stream().filter(e -> onlineActivatedAddresses.contains(((Node.Endpoint)e.getKey()).getHostPort())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        RepairMethod repairMethod = wanted = this.forcedRepairMethod == null ? fallbackRepairMethod : this.forcedRepairMethod;
        if (wanted == null) {
            throw new IllegalArgumentException("Some nodes are offline. Unable to determine what kind of repair to run. Please refer to the Troubleshooting Guide.");
        }
        this.output.info("Repairing configuration by running a " + (Object)((Object)wanted) + "...", new Object[0]);
        this.runConfigurationRepair(onlineActivatedEndpoints, allNodes.size(), (ChangeRequestState)(wanted == RepairMethod.COMMIT ? ChangeRequestState.COMMITTED : (wanted == RepairMethod.ROLLBACK ? ChangeRequestState.ROLLED_BACK : null)));
        this.output.info("Configuration is repaired.", new Object[0]);
    }
}

