/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.diagnostic.client.DiagnosticService;
import org.terracotta.diagnostic.client.connection.DiagnosticServiceProvider;
import org.terracotta.diagnostic.client.connection.DiagnosticServices;
import org.terracotta.diagnostic.client.connection.MultiDiagnosticServiceProvider;
import org.terracotta.diagnostic.model.LogicalServerState;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.LockContext;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.DynamicConfigNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.LockConfigNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.TopologyNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.UnlockConfigNomadChange;
import org.terracotta.dynamic_config.api.service.ConfigurationConsistencyAnalyzer;
import org.terracotta.dynamic_config.api.service.DynamicConfigService;
import org.terracotta.dynamic_config.api.service.NomadChangeInfo;
import org.terracotta.dynamic_config.api.service.TopologyService;
import org.terracotta.dynamic_config.cli.api.command.Injector;
import org.terracotta.dynamic_config.cli.api.nomad.LockAwareNomadManager;
import org.terracotta.dynamic_config.cli.api.nomad.NomadManager;
import org.terracotta.dynamic_config.cli.api.output.OutputService;
import org.terracotta.dynamic_config.cli.api.restart.RestartProgress;
import org.terracotta.dynamic_config.cli.api.restart.RestartService;
import org.terracotta.dynamic_config.cli.api.stop.StopProgress;
import org.terracotta.dynamic_config.cli.api.stop.StopService;
import org.terracotta.inet.HostPort;
import org.terracotta.json.ObjectMapperFactory;
import org.terracotta.nomad.client.change.ChangeResultReceiver;
import org.terracotta.nomad.client.recovery.RecoveryResultReceiver;
import org.terracotta.nomad.client.results.DiscoverResultsReceiver;
import org.terracotta.nomad.client.results.NomadFailureReceiver;
import org.terracotta.nomad.server.ChangeRequestState;

public abstract class RemoteAction
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAction.class);
    @Injector.Inject
    public MultiDiagnosticServiceProvider multiDiagnosticServiceProvider;
    @Injector.Inject
    public DiagnosticServiceProvider diagnosticServiceProvider;
    @Injector.Inject
    public NomadManager<NodeContext> nomadManager;
    @Injector.Inject
    public RestartService restartService;
    @Injector.Inject
    public StopService stopService;
    @Injector.Inject
    public OutputService output;
    @Injector.Inject
    public ObjectMapperFactory objectMapperFactory;

    protected String toJson(Object o) {
        try {
            return this.objectMapperFactory.pretty().create().setSerializationInclusion(JsonInclude.Include.ALWAYS).setDefaultPropertyInclusion(JsonInclude.Include.ALWAYS).writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void licenseValidation(HostPort hostPort, Cluster cluster) {
        LOGGER.trace("licenseValidation({}, {})", (Object)hostPort, (Object)cluster);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(hostPort.createInetSocketAddress());){
            if (((TopologyService)diagnosticService.getProxy(TopologyService.class)).validateAgainstLicense(cluster)) {
                LOGGER.debug("License validation passed: configuration change(s) can be applied");
            } else {
                LOGGER.debug("License validation skipped: no license installed");
            }
        }
    }

    private void activateNomadSystem(Collection<Node.Endpoint> newNodes, Cluster cluster, String licenseContent) {
        this.output.info("Activating nodes: " + RemoteAction.toString(newNodes), new Object[0]);
        try (DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchOnlineDiagnosticServices(RemoteAction.endpointsToMap(newNodes));){
            RemoteAction.dynamicConfigServices(diagnosticServices).map(Tuple2::getT2).forEach(service -> service.activate(cluster, licenseContent));
            if (licenseContent == null) {
                this.output.info("No license specified for activation. If a license was previously configured, it will take effect. If you are attaching a node, the license will be synced.", new Object[0]);
            } else {
                this.output.info("License installation successful", new Object[0]);
            }
        }
    }

    private void restartNodes(Collection<Node.Endpoint> newNodes, Measure<TimeUnit> restartDelay, Measure<TimeUnit> restartWaitTime) {
        this.output.info("Restarting nodes: " + RemoteAction.toString(newNodes), new Object[0]);
        this.restartNodes(newNodes, Duration.ofMillis(restartWaitTime.getQuantity((Enum)TimeUnit.MILLISECONDS)), Duration.ofMillis(restartDelay.getQuantity((Enum)TimeUnit.MILLISECONDS)), EnumSet.of(LogicalServerState.ACTIVE, new LogicalServerState[]{LogicalServerState.ACTIVE_RECONNECTING, LogicalServerState.ACTIVE_SUSPENDED, LogicalServerState.PASSIVE, LogicalServerState.PASSIVE_SUSPENDED, LogicalServerState.SYNCHRONIZING}));
        this.output.info("All nodes came back up", new Object[0]);
    }

    protected final void activateNodes(Collection<Node.Endpoint> newNodes, Cluster cluster, Path licenseFile, Measure<TimeUnit> restartDelay, Measure<TimeUnit> restartWaitTime) {
        this.activateNomadSystem(newNodes, cluster, RemoteAction.read(licenseFile));
        this.runClusterActivation(newNodes, cluster);
        this.restartNodes(newNodes, restartDelay, restartWaitTime);
    }

    protected final void activateStripe(Collection<Node.Endpoint> newNodes, Cluster cluster, Node.Endpoint destination, Measure<TimeUnit> restartDelay, Measure<TimeUnit> restartWaitTime) {
        this.activateNomadSystem(newNodes, cluster, this.getLicenseContentFrom(destination).orElse(null));
        this.runClusterActivation(newNodes, cluster);
        this.syncNomadChangesTo(newNodes, this.getChangeHistory(destination), cluster);
        this.restartNodes(newNodes, restartDelay, restartWaitTime);
    }

    private Optional<String> getLicenseContentFrom(Node.Endpoint node) {
        LOGGER.trace("getLicenseContent({})", (Object)node);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(node.getHostPort().createInetSocketAddress());){
            Optional optional = ((DynamicConfigService)diagnosticService.getProxy(DynamicConfigService.class)).getLicenseContent();
            return optional;
        }
    }

    protected final NomadChangeInfo[] getChangeHistory(Node.Endpoint node) {
        return this.getChangeHistory(node.getHostPort());
    }

    protected final NomadChangeInfo[] getChangeHistory(HostPort hostPort) {
        LOGGER.trace("getChangeHistory({})", (Object)hostPort);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(hostPort.createInetSocketAddress());){
            NomadChangeInfo[] nomadChangeInfoArray = ((TopologyService)diagnosticService.getProxy(TopologyService.class)).getChangeHistory();
            return nomadChangeInfoArray;
        }
    }

    private void syncNomadChangesTo(Collection<Node.Endpoint> newNodes, NomadChangeInfo[] nomadChanges, Cluster cluster) {
        this.output.info("Sync'ing nomad changes to nodes : {}", new Object[]{RemoteAction.toString(newNodes)});
        try (DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchOnlineDiagnosticServices(RemoteAction.endpointsToMap(newNodes));){
            RemoteAction.dynamicConfigServices(diagnosticServices).map(Tuple2::getT2).forEach(service -> service.resetAndSync(nomadChanges, cluster));
            this.output.info("Nomad changes sync successful", new Object[0]);
        }
    }

    protected final boolean mustBeRestarted(Node.Endpoint endpoint) {
        return this.mustBeRestarted(endpoint.getHostPort());
    }

    protected final boolean mustBeRestarted(HostPort expectedOnlineNode) {
        LOGGER.trace("mustBeRestarted({})", (Object)expectedOnlineNode);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.createInetSocketAddress());){
            boolean bl = ((TopologyService)diagnosticService.getProxy(TopologyService.class)).mustBeRestarted();
            return bl;
        }
    }

    protected final boolean hasIncompleteChange(Node.Endpoint endpoint) {
        return this.hasIncompleteChange(endpoint.getHostPort());
    }

    protected final boolean hasIncompleteChange(HostPort expectedOnlineNode) {
        LOGGER.trace("hasIncompleteChange({})", (Object)expectedOnlineNode);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.createInetSocketAddress());){
            boolean bl = ((TopologyService)diagnosticService.getProxy(TopologyService.class)).hasIncompleteChange();
            return bl;
        }
    }

    protected final ConfigurationConsistencyAnalyzer analyzeNomadConsistency(Map<Node.Endpoint, LogicalServerState> allNodes) {
        LOGGER.trace("analyzeNomadConsistency({})", allNodes);
        Map<HostPort, LogicalServerState> addresses = allNodes.entrySet().stream().collect(Collectors.toMap(e -> ((Node.Endpoint)e.getKey()).getHostPort(), Map.Entry::getValue));
        ConfigurationConsistencyAnalyzer configurationConsistencyAnalyzer = new ConfigurationConsistencyAnalyzer(addresses);
        this.nomadManager.runConfigurationDiscovery(allNodes, (DiscoverResultsReceiver<NodeContext>)configurationConsistencyAnalyzer);
        return configurationConsistencyAnalyzer;
    }

    protected final void runConfigurationRepair(Map<Node.Endpoint, LogicalServerState> onlineActivatedNodes, int totalNodeCount, ChangeRequestState forcedState) {
        LOGGER.trace("runConfigurationRepair({}, {})", (Object)RemoteAction.toString(onlineActivatedNodes.keySet()), (Object)forcedState);
        NomadFailureReceiver failures = new NomadFailureReceiver();
        this.nomadManager.runConfigurationRepair(onlineActivatedNodes, totalNodeCount, (RecoveryResultReceiver<NodeContext>)failures, forcedState);
        failures.reThrowReasons();
    }

    protected final void runConfigurationChange(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes, DynamicConfigNomadChange change) {
        LOGGER.trace("runConfigurationChange({}, {})", onlineNodes, (Object)change);
        NomadFailureReceiver failures = new NomadFailureReceiver();
        this.nomadManager.runConfigurationChange(destinationCluster, onlineNodes, change, (ChangeResultReceiver<NodeContext>)failures);
        failures.reThrowReasons();
    }

    protected final String lock(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes, String ownerName, String tags) {
        return this.lock(destinationCluster, onlineNodes, new LockContext(UUID.randomUUID().toString(), ownerName, tags));
    }

    protected final String lock(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes, LockContext lockContext) {
        this.output.info("Trying to lock the config...", new Object[0]);
        this.runConfigurationChange(destinationCluster, onlineNodes, (DynamicConfigNomadChange)new LockConfigNomadChange(lockContext));
        this.output.info("Config locked.", new Object[0]);
        this.nomadManager = new LockAwareNomadManager<NodeContext>(lockContext.getToken(), this.nomadManager);
        return lockContext.getToken();
    }

    protected final void unlock(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes) {
        this.unlockInternal(destinationCluster, onlineNodes, false);
    }

    protected final void forceUnlock(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes) {
        this.unlockInternal(destinationCluster, onlineNodes, true);
    }

    private void unlockInternal(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes, boolean force) {
        this.output.info("Trying to unlock the config...", new Object[0]);
        this.runConfigurationChange(destinationCluster, onlineNodes, (DynamicConfigNomadChange)new UnlockConfigNomadChange(force));
        this.output.info("Config unlocked.", new Object[0]);
        if (this.nomadManager instanceof LockAwareNomadManager) {
            this.nomadManager = ((LockAwareNomadManager)this.nomadManager).getUnderlying();
        }
    }

    protected final void runTopologyChange(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes, TopologyNomadChange change) {
        LOGGER.trace("runTopologyChange({}, {})", onlineNodes, (Object)change);
        NomadFailureReceiver failures = new NomadFailureReceiver();
        this.nomadManager.runConfigurationChange(destinationCluster, onlineNodes, (DynamicConfigNomadChange)change, (ChangeResultReceiver<NodeContext>)failures);
        failures.reThrowReasons();
    }

    protected final void runClusterActivation(Collection<Node.Endpoint> expectedOnlineNodes, Cluster cluster) {
        LOGGER.trace("runClusterActivation({}, {})", expectedOnlineNodes, (Object)cluster.toShapeString());
        NomadFailureReceiver failures = new NomadFailureReceiver();
        this.nomadManager.runClusterActivation(expectedOnlineNodes, cluster, (ChangeResultReceiver<NodeContext>)failures);
        failures.reThrowReasons();
        LOGGER.debug("Configuration directories have been created for all nodes");
    }

    protected final LogicalServerState getLogicalServerState(Node.Endpoint expectedOnlineNode) {
        return this.getLogicalServerState(expectedOnlineNode.getHostPort());
    }

    protected final LogicalServerState getLogicalServerState(HostPort expectedOnlineNode) {
        LOGGER.trace("getLogicalServerState({})", (Object)expectedOnlineNode);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.createInetSocketAddress());){
            LogicalServerState logicalServerState = diagnosticService.getLogicalServerState();
            return logicalServerState;
        }
    }

    protected final Map<Node.Endpoint, LogicalServerState> getLogicalServerStates(Collection<Node.Endpoint> endpoints) {
        LOGGER.trace("getLogicalServerStates({})", endpoints);
        try (DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchDiagnosticServices(RemoteAction.endpointsToMap(endpoints), null);){
            LinkedHashMap status = endpoints.stream().collect(Collectors.toMap(Function.identity(), endpoint -> diagnosticServices.getDiagnosticService((Object)endpoint.getNodeUID()).map(DiagnosticService::getLogicalServerState).orElse(LogicalServerState.UNREACHABLE), (o1, o2) -> {
                throw new UnsupportedOperationException();
            }, LinkedHashMap::new));
            status.forEach((address, state) -> {
                if (state.isUnreacheable()) {
                    this.output.info(" - {} is not reachable", new Object[]{address});
                }
            });
            LinkedHashMap linkedHashMap = status;
            return linkedHashMap;
        }
    }

    protected final Cluster getUpcomingCluster(Node.Endpoint expectedOnlineNode) {
        return this.getUpcomingCluster(expectedOnlineNode.getHostPort());
    }

    protected final Cluster getUpcomingCluster(HostPort expectedOnlineNode) {
        LOGGER.trace("getUpcomingCluster({})", (Object)expectedOnlineNode);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.createInetSocketAddress());){
            Cluster cluster = ((TopologyService)diagnosticService.getProxy(TopologyService.class)).getUpcomingNodeContext().getCluster();
            return cluster;
        }
    }

    protected final Cluster getUpcomingCluster(Collection<HostPort> nodes) {
        LOGGER.trace("getUpcomingCluster({})", nodes);
        return this.withAnyOnlineDiagnosticService(nodes, (hostPort, diagnosticService) -> ((TopologyService)diagnosticService.getProxy(TopologyService.class)).getUpcomingNodeContext().getCluster());
    }

    protected final void setUpcomingCluster(Collection<Node.Endpoint> expectedOnlineNodes, Cluster cluster) {
        LOGGER.trace("setUpcomingCluster({})", expectedOnlineNodes);
        for (Node.Endpoint expectedOnlineNode : expectedOnlineNodes) {
            DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.getHostPort().createInetSocketAddress());
            Throwable throwable = null;
            try {
                ((DynamicConfigService)diagnosticService.getProxy(DynamicConfigService.class)).setUpcomingCluster(cluster);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (diagnosticService == null) continue;
                if (throwable != null) {
                    try {
                        diagnosticService.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                diagnosticService.close();
            }
        }
    }

    protected final Cluster getRuntimeCluster(Node.Endpoint expectedOnlineNode) {
        return this.getRuntimeCluster(expectedOnlineNode.getHostPort());
    }

    protected final Cluster getRuntimeCluster(HostPort expectedOnlineNode) {
        LOGGER.trace("getRuntimeCluster({})", (Object)expectedOnlineNode);
        return ((NodeContext)this.getRuntimeNodeContext((HostPort)expectedOnlineNode).t2).getCluster();
    }

    protected final Cluster getRuntimeCluster(Collection<HostPort> nodes) {
        LOGGER.trace("getRuntimeCluster({})", nodes);
        return this.withAnyOnlineDiagnosticService(nodes, (hostPort, diagnosticService) -> ((TopologyService)diagnosticService.getProxy(TopologyService.class)).getRuntimeNodeContext().getCluster());
    }

    protected final <V> V withAnyOnlineDiagnosticService(Collection<HostPort> nodes, BiFunction<HostPort, DiagnosticService, V> fn) {
        try (DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchAnyOnlineDiagnosticService(RemoteAction.toAddr(nodes, Function.identity(), HostPort::createInetSocketAddress));){
            Map.Entry entry = diagnosticServices.getOnlineEndpoints().entrySet().iterator().next();
            V v = fn.apply((HostPort)entry.getKey(), (DiagnosticService)entry.getValue());
            return v;
        }
    }

    protected final Node.Endpoint getEndpoint(HostPort expectedOnlineNode) {
        LOGGER.trace("getEndpoint({})", (Object)expectedOnlineNode);
        return (Node.Endpoint)this.getRuntimeNodeContext((HostPort)expectedOnlineNode).t1;
    }

    protected final Tuple2<Node.Endpoint, NodeContext> getRuntimeNodeContext(HostPort expectedOnlineNode) {
        LOGGER.trace("NodeContext({})", (Object)expectedOnlineNode);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.createInetSocketAddress());){
            NodeContext nodeContext = ((TopologyService)diagnosticService.getProxy(TopologyService.class)).getRuntimeNodeContext();
            Tuple2 tuple2 = Tuple2.tuple2((Object)nodeContext.getNode().determineEndpoint(expectedOnlineNode), (Object)nodeContext);
            return tuple2;
        }
    }

    protected final Tuple2<Node.Endpoint, NodeContext> getUpcomingNodeContext(HostPort expectedOnlineNode) {
        LOGGER.trace("NodeContext({})", (Object)expectedOnlineNode);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.createInetSocketAddress());){
            NodeContext nodeContext = ((TopologyService)diagnosticService.getProxy(TopologyService.class)).getUpcomingNodeContext();
            Tuple2 tuple2 = Tuple2.tuple2((Object)nodeContext.getNode().determineEndpoint(expectedOnlineNode), (Object)nodeContext);
            return tuple2;
        }
    }

    protected final void restartNodes(Collection<Node.Endpoint> endpoints, Duration maximumWaitTime, Duration restartDelay, Collection<LogicalServerState> acceptedStates) {
        LOGGER.trace("restartNodes({}, {})", endpoints, (Object)maximumWaitTime);
        RestartProgress progress = this.restartService.restartNodes(endpoints, restartDelay, acceptedStates);
        this.followRestart(progress, endpoints, maximumWaitTime);
    }

    protected final void restartNodesIfActives(Collection<Node.Endpoint> endpoints, Duration maximumWaitTime, Duration restartDelay, Collection<LogicalServerState> acceptedStates) {
        LOGGER.trace("restartNodesIfActives({}, {})", endpoints, (Object)maximumWaitTime);
        RestartProgress progress = this.restartService.restartNodesIfActives(endpoints, restartDelay, acceptedStates);
        this.followRestart(progress, endpoints, maximumWaitTime);
    }

    protected final void restartNodesIfPassives(Collection<Node.Endpoint> endpoints, Duration maximumWaitTime, Duration restartDelay, Collection<LogicalServerState> acceptedStates) {
        LOGGER.trace("restartNodesIfPassives({}, {})", endpoints, (Object)maximumWaitTime);
        RestartProgress progress = this.restartService.restartNodesIfPassives(endpoints, restartDelay, acceptedStates);
        this.followRestart(progress, endpoints, maximumWaitTime);
    }

    private void followRestart(RestartProgress progress, Collection<Node.Endpoint> endpoints, Duration maximumWaitTime) {
        try {
            progress.getErrors().forEach((address, e) -> LOGGER.warn("Unable to ask node: {} to restart: please restart it manually.", address));
            progress.onRestarted((endpoint, state) -> this.output.info("Node: {} has restarted in state: {}", new Object[]{endpoint, state}));
            Map<Node.Endpoint, LogicalServerState> restarted = progress.await(maximumWaitTime);
            TreeSet<Node.Endpoint> missing = new TreeSet<Node.Endpoint>(Comparator.comparing(Node.Endpoint::toString));
            missing.addAll(endpoints);
            missing.removeAll(progress.getErrors().keySet());
            missing.removeAll(restarted.keySet());
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Some nodes may have failed to restart within " + maximumWaitTime.getSeconds() + " seconds. " + System.lineSeparator() + "This should be confirmed by examining the state of the nodes listed below." + System.lineSeparator() + "Note: if the cluster did not have security configured before activation but has security configured post-activation, or vice-versa, then the nodes may have in fact successfully restarted.  This should be confirmed.  Nodes:" + System.lineSeparator() + " - " + missing.stream().map(Node.Endpoint::toString).collect(Collectors.joining(System.lineSeparator() + " - ")));
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Restart has been interrupted", e2);
        }
    }

    protected final void stopNodes(Collection<Node.Endpoint> addresses, Duration maximumWaitTime, Duration restartDelay) {
        LOGGER.trace("stopNodes({}, {})", addresses, (Object)maximumWaitTime);
        try {
            StopProgress progress = this.stopService.stopNodes(addresses, restartDelay);
            progress.getErrors().forEach((address, e) -> LOGGER.warn("Unable to ask node: {} to stop: please stop it manually.", address));
            progress.onStopped(endpoint -> this.output.info("Node: {} has stopped", new Object[]{endpoint}));
            Collection<Node.Endpoint> stopped = progress.await(maximumWaitTime);
            TreeSet<Node.Endpoint> missing = new TreeSet<Node.Endpoint>(Comparator.comparing(Node.Endpoint::toString));
            missing.addAll(addresses);
            missing.removeAll(progress.getErrors().keySet());
            missing.removeAll(stopped);
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Some nodes failed to stop within " + maximumWaitTime.getSeconds() + " seconds:" + System.lineSeparator() + " - " + missing.stream().map(Node.Endpoint::toString).collect(Collectors.joining(System.lineSeparator() + " - ")));
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Stop has been interrupted", e2);
        }
    }

    protected final Collection<Node.Endpoint> findRuntimePeers(HostPort expectedOnlineNode) {
        LOGGER.trace("findRuntimePeers({})", (Object)expectedOnlineNode);
        Cluster cluster = this.getRuntimeCluster(expectedOnlineNode);
        Collection peers = cluster.determineEndpoints(new HostPort[]{expectedOnlineNode});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Discovered nodes:{} through: {}", (Object)RemoteAction.toString(peers), (Object)expectedOnlineNode);
        }
        return peers;
    }

    protected final Map<Node.Endpoint, LogicalServerState> findRuntimePeersStatus(HostPort expectedOnlineNode) {
        LOGGER.trace("findRuntimePeersStatus({})", (Object)expectedOnlineNode);
        Cluster cluster = this.getRuntimeCluster(expectedOnlineNode);
        Collection endpoints = cluster.determineEndpoints(new HostPort[]{expectedOnlineNode});
        this.output.info("Connecting to: {} (this can take time if some nodes are not reachable)", new Object[]{RemoteAction.toString(endpoints)});
        return this.getLogicalServerStates(endpoints);
    }

    protected final Map<Node.Endpoint, LogicalServerState> findRuntimePeersStatus(Collection<HostPort> expectedOnlineNodes) {
        LOGGER.trace("findRuntimePeersStatus({})", expectedOnlineNodes);
        Cluster cluster = this.getRuntimeCluster(expectedOnlineNodes);
        Collection endpoints = cluster.determineEndpoints(expectedOnlineNodes);
        this.output.info("Connecting to: {} (this can take time if some nodes are not reachable)", new Object[]{RemoteAction.toString(endpoints)});
        return this.getLogicalServerStates(endpoints);
    }

    protected final Map<Node.Endpoint, LogicalServerState> findOnlineRuntimePeers(Node.Endpoint expectedOnlineNode) {
        return this.findOnlineRuntimePeers(expectedOnlineNode.getHostPort());
    }

    protected final Map<Node.Endpoint, LogicalServerState> findOnlineRuntimePeers(HostPort expectedOnlineNode) {
        LOGGER.trace("findOnlineRuntimePeers({})", (Object)expectedOnlineNode);
        Map<Node.Endpoint, LogicalServerState> nodes = this.findRuntimePeersStatus(expectedOnlineNode);
        return this.filterOnlineNodes(nodes);
    }

    protected final LinkedHashMap<Node.Endpoint, LogicalServerState> filterOnlineNodes(Map<Node.Endpoint, LogicalServerState> nodes) {
        return this.filter(nodes, (addr, state) -> !state.isUnknown() && !state.isUnreacheable());
    }

    protected final <K> LinkedHashMap<K, LogicalServerState> filter(Map<K, LogicalServerState> nodes, BiPredicate<K, LogicalServerState> predicate) {
        return nodes.entrySet().stream().filter(e -> predicate.test(e.getKey(), (LogicalServerState)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> {
            throw new UnsupportedOperationException();
        }, LinkedHashMap::new));
    }

    protected final void ensurePassivesAreAllOnline(Cluster cluster, Map<Node.Endpoint, LogicalServerState> onlineNodes) {
        Collection actives = onlineNodes.entrySet().stream().filter(e -> ((LogicalServerState)e.getValue()).isActive()).map(Map.Entry::getKey).map(Node.Endpoint::getNodeName).collect(Collectors.toCollection(TreeSet::new));
        Collection passives = onlineNodes.entrySet().stream().filter(e -> ((LogicalServerState)e.getValue()).isPassive()).map(Map.Entry::getKey).map(Node.Endpoint::getNodeName).collect(Collectors.toCollection(TreeSet::new));
        Collection expectedPassives = cluster.getNodes().stream().map(Node::getName).collect(Collectors.toCollection(TreeSet::new));
        expectedPassives.removeAll(actives);
        if (!passives.containsAll(expectedPassives)) {
            TreeSet missing = new TreeSet(expectedPassives);
            missing.removeAll(passives);
            throw new IllegalStateException("Expected these nodes to be in PASSIVE state: " + RemoteAction.toString(expectedPassives) + ", but nodes: " + RemoteAction.toString(missing) + " are not");
        }
    }

    protected final void ensureActivesAreAllOnline(Cluster cluster, Map<Node.Endpoint, LogicalServerState> onlineNodes) {
        if (onlineNodes.isEmpty()) {
            throw new IllegalStateException("Expected 1 active per stripe, but found no online node.");
        }
        List actives = onlineNodes.entrySet().stream().filter(e -> ((LogicalServerState)e.getValue()).isActive()).map(Map.Entry::getKey).map(Node.Endpoint::getNodeName).collect(Collectors.toList());
        if (cluster.getStripeCount() != actives.size()) {
            throw new IllegalStateException("Expected 1 active per stripe, but only these nodes are active: " + RemoteAction.toString(actives));
        }
    }

    protected final void ensureNodesAreEitherActiveOrPassive(Map<Node.Endpoint, LogicalServerState> onlineNodes) {
        for (Map.Entry<Node.Endpoint, LogicalServerState> entry : onlineNodes.entrySet()) {
            if (!entry.getValue().isStarting() && !entry.getValue().isSynchronizing()) continue;
            LOGGER.info("Waiting for node: {} to become passive or active...", (Object)entry.getKey());
            while (entry.getValue().isSynchronizing() || entry.getValue().isStarting()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                entry.setValue(this.getLogicalServerState(entry.getKey()));
            }
            LOGGER.info("Node: {} is: {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        onlineNodes.forEach((addr, state) -> {
            if (!state.isActive() && !state.isPassive()) {
                throw new IllegalStateException("Unable to update node: " + addr + " that is currently in state: " + state + ". Please ensure all online nodes are either ACTIVE or PASSIVE before sending any update.");
            }
        });
    }

    protected final boolean isActivated(Node.Endpoint expectedOnlineNode) {
        return this.isActivated(expectedOnlineNode.getHostPort());
    }

    protected final boolean isActivated(HostPort expectedOnlineNode) {
        LOGGER.trace("isActivated({})", (Object)expectedOnlineNode);
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.createInetSocketAddress());){
            boolean bl = ((TopologyService)diagnosticService.getProxy(TopologyService.class)).isActivated();
            return bl;
        }
    }

    protected final Node.Endpoint findAnyOnlineNode(Collection<HostPort> nodes) {
        LOGGER.trace("findAnyOnlineNode({})", nodes);
        NodeContext nodeContext = this.withAnyOnlineDiagnosticService(nodes, (hostPort, diagnosticService) -> ((TopologyService)diagnosticService.getProxy(TopologyService.class)).getRuntimeNodeContext());
        Cluster cluster = nodeContext.getCluster();
        return (Node.Endpoint)cluster.determineEndpoint(nodeContext.getNodeUID(), nodes).get();
    }

    protected final void resetAndStop(HostPort expectedOnlineNode) {
        this.output.info("Reset node: {}. Node will stop...", new Object[]{expectedOnlineNode});
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.createInetSocketAddress());){
            DynamicConfigService proxy = (DynamicConfigService)diagnosticService.getProxy(DynamicConfigService.class);
            proxy.reset();
            proxy.stop(Duration.ofSeconds(5L));
        }
    }

    protected final void reset(Node.Endpoint expectedOnlineNode) {
        this.output.info("Reset node: {}", new Object[]{expectedOnlineNode.getHostPort()});
        try (DiagnosticService diagnosticService = this.diagnosticServiceProvider.fetchDiagnosticService(expectedOnlineNode.getHostPort().createInetSocketAddress());){
            DynamicConfigService proxy = (DynamicConfigService)diagnosticService.getProxy(DynamicConfigService.class);
            proxy.reset();
        }
    }

    protected final boolean areAllNodesActivated(Collection<Node.Endpoint> expectedOnlineNodes) {
        LOGGER.trace("areAllNodesActivated({})", expectedOnlineNodes);
        Map<UID, InetSocketAddress> map = RemoteAction.endpointsToMap(expectedOnlineNodes);
        try (DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchOnlineDiagnosticServices(map);){
            Map<UID, HostPort> map2 = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> HostPort.create((InetSocketAddress)((InetSocketAddress)e.getValue()))));
            Map<Boolean, Collection> activations = RemoteAction.topologyServices(diagnosticServices).map(tuple -> tuple.map(Function.identity(), TopologyService::isActivated)).collect(Collectors.groupingBy(Tuple2::getT2, Collectors.mapping(tuple -> (HostPort)map2.get(tuple.getT1()), Collectors.toCollection(() -> new TreeSet<HostPort>(Comparator.comparing(HostPort::toString))))));
            if (activations.isEmpty()) {
                throw new IllegalArgumentException("Cluster is empty or offline");
            }
            if (activations.size() == 2) {
                throw new IllegalStateException("Detected a mix of activated and unconfigured nodes (or being repaired). Activated: " + activations.get(Boolean.TRUE) + ", Unconfigured: " + activations.get(Boolean.FALSE));
            }
            boolean bl = activations.keySet().iterator().next();
            return bl;
        }
    }

    protected final void upgradeLicense(Collection<Node.Endpoint> expectedOnlineNodes, Path licenseFile) {
        String xml;
        LOGGER.trace("upgradeLicense({}, {})", expectedOnlineNodes, (Object)licenseFile);
        try {
            xml = licenseFile == null ? null : new String(Files.readAllBytes(licenseFile), StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        try (DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchOnlineDiagnosticServices(RemoteAction.endpointsToMap(expectedOnlineNodes));){
            RemoteAction.dynamicConfigServices(diagnosticServices).map(tuple -> {
                try {
                    ((DynamicConfigService)tuple.t2).upgradeLicense(xml);
                    return null;
                }
                catch (RuntimeException e) {
                    LOGGER.debug("License upgrade failed on node {}: {}", tuple.t1, (Object)e.getMessage());
                    return e;
                }
            }).filter(Objects::nonNull).reduce((result, element) -> {
                result.addSuppressed((Throwable)element);
                return result;
            }).ifPresent(e -> {
                throw e;
            });
        }
    }

    protected static Map<UID, InetSocketAddress> endpointsToMap(Collection<Node.Endpoint> nodes) {
        return RemoteAction.toAddr(nodes, Node.Endpoint::getNodeUID, endpoint -> endpoint.getHostPort().createInetSocketAddress());
    }

    protected static Map<HostPort, InetSocketAddress> hostPortsToMap(Collection<HostPort> nodes) {
        return RemoteAction.toAddr(nodes, Function.identity(), HostPort::createInetSocketAddress);
    }

    protected static <K, E> Map<K, InetSocketAddress> toAddr(Collection<E> keys, Function<E, K> key, Function<E, InetSocketAddress> val) {
        return keys.stream().collect(Collectors.toMap(key, val, (res, el) -> el));
    }

    protected static <K> Stream<Tuple2<K, TopologyService>> topologyServices(DiagnosticServices<K> diagnosticServices) {
        return diagnosticServices.map((uid, diagnosticService) -> (TopologyService)diagnosticService.getProxy(TopologyService.class));
    }

    protected static <K> Stream<Tuple2<K, DynamicConfigService>> dynamicConfigServices(DiagnosticServices<K> diagnosticServices) {
        return diagnosticServices.map((uid, diagnosticService) -> (DynamicConfigService)diagnosticService.getProxy(DynamicConfigService.class));
    }

    protected static String toString(Collection<?> items) {
        return items.stream().map(Object::toString).sorted().collect(Collectors.joining(", "));
    }

    private static String read(Path path) {
        if (path == null) {
            return null;
        }
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

