/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import com.fasterxml.jackson.databind.Module;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Version;
import org.terracotta.diagnostic.client.connection.CompatibleDiagnosticServiceProvider;
import org.terracotta.diagnostic.client.connection.ConcurrencySizing;
import org.terracotta.diagnostic.client.connection.ConcurrentDiagnosticServiceProvider;
import org.terracotta.diagnostic.client.connection.DefaultDiagnosticServiceProvider;
import org.terracotta.diagnostic.client.connection.DiagnosticServiceProvider;
import org.terracotta.diagnostic.client.connection.MultiDiagnosticServiceProvider;
import org.terracotta.diagnostic.model.KitInformation;
import org.terracotta.dynamic_config.api.json.DynamicConfigApiJsonModule;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.cli.api.command.Configuration;
import org.terracotta.dynamic_config.cli.api.command.ServiceProvider;
import org.terracotta.dynamic_config.cli.api.nomad.DefaultNomadManager;
import org.terracotta.dynamic_config.cli.api.nomad.LockAwareNomadManager;
import org.terracotta.dynamic_config.cli.api.nomad.NomadManager;
import org.terracotta.dynamic_config.cli.api.output.OutputService;
import org.terracotta.dynamic_config.cli.api.restart.RestartService;
import org.terracotta.dynamic_config.cli.api.stop.StopService;
import org.terracotta.json.ObjectMapperFactory;
import org.terracotta.nomad.NomadEnvironment;
import org.terracotta.nomad.entity.client.NomadEntity;
import org.terracotta.nomad.entity.client.NomadEntityProvider;

public class OssServiceProvider
implements ServiceProvider {
    @Override
    public Collection<Object> createServices(Configuration config) {
        return Arrays.asList(this.createDiagnosticServiceProvider(config), this.createMultiDiagnosticServiceProvider(config), this.createNomadManager(config), this.createRestartService(config), this.createStopService(config), this.createObjectMapperFactory(config), this.createNomadEntityProvider(config), this.createOutputService(config));
    }

    protected OutputService createOutputService(Configuration config) {
        return config.getOutputService();
    }

    protected StopService createStopService(Configuration config) {
        return new StopService(this.createDiagnosticServiceProvider(config), this.getConcurrencySizing(config));
    }

    protected RestartService createRestartService(Configuration config) {
        return new RestartService(this.createDiagnosticServiceProvider(config), this.getConcurrencySizing(config));
    }

    protected NomadManager<NodeContext> createNomadManager(Configuration config) {
        NomadManager<NodeContext> nomadManager = new DefaultNomadManager<NodeContext>(new NomadEnvironment(), (MultiDiagnosticServiceProvider)this.createMultiDiagnosticServiceProvider(config), this.createNomadEntityProvider(config));
        if (config.getLockToken() != null) {
            nomadManager = new LockAwareNomadManager<NodeContext>(config.getLockToken(), nomadManager);
        }
        return nomadManager;
    }

    protected NomadEntityProvider createNomadEntityProvider(Configuration config) {
        return new NomadEntityProvider("CONFIG-TOOL", this.getConnectionTimeout(config), new NomadEntity.Settings().setRequestTimeout(this.getEntityOperationTimeout(config)), config.getSecurityRootDirectory());
    }

    protected ConcurrentDiagnosticServiceProvider createMultiDiagnosticServiceProvider(Configuration config) {
        return new ConcurrentDiagnosticServiceProvider(this.createDiagnosticServiceProvider(config), this.getConnectionTimeout(config), this.getConcurrencySizing(config));
    }

    protected DiagnosticServiceProvider createDiagnosticServiceProvider(Configuration config) {
        DefaultDiagnosticServiceProvider diagnosticServiceProvider = new DefaultDiagnosticServiceProvider("CONFIG-TOOL", this.getConnectionTimeout(config), this.getRequestTimeout(config), config.getSecurityRootDirectory(), this.createObjectMapperFactory(config));
        return new CompatibleDiagnosticServiceProvider((DiagnosticServiceProvider)diagnosticServiceProvider){

            protected boolean isCompatible(KitInformation kitInformation) {
                return kitInformation.getVersion().greaterThan(Version.valueOf((String)"5.7"));
            }
        };
    }

    protected ObjectMapperFactory createObjectMapperFactory(Configuration config) {
        return new ObjectMapperFactory().withModule((Module)new DynamicConfigApiJsonModule());
    }

    protected Duration getEntityOperationTimeout(Configuration config) {
        return Duration.ofMillis(config.getEntityOperationTimeout().getQuantity((Enum)TimeUnit.MILLISECONDS));
    }

    protected Duration getRequestTimeout(Configuration config) {
        return Duration.ofMillis(config.getRequestTimeout().getQuantity((Enum)TimeUnit.MILLISECONDS));
    }

    protected Duration getConnectionTimeout(Configuration config) {
        return Duration.ofMillis(config.getConnectionTimeout().getQuantity((Enum)TimeUnit.MILLISECONDS));
    }

    protected ConcurrencySizing getConcurrencySizing(Configuration config) {
        return new ConcurrencySizing();
    }
}

