/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ObjectMapperFactory {
    private final boolean pretty;
    private final List<Module> modules;
    private final String eol;

    public ObjectMapperFactory() {
        this(Collections.emptyList(), false, "\n");
    }

    private ObjectMapperFactory(List<Module> modules, boolean pretty, String eol) {
        this.pretty = pretty;
        this.modules = new ArrayList<Module>(modules);
        this.eol = eol;
    }

    public ObjectMapperFactory pretty() {
        return this.pretty(true);
    }

    public ObjectMapperFactory eol(String eol) {
        return new ObjectMapperFactory(this.modules, this.pretty, eol);
    }

    public ObjectMapperFactory systemEOL() {
        return this.eol(System.lineSeparator());
    }

    public ObjectMapperFactory pretty(boolean pretty) {
        return new ObjectMapperFactory(this.modules, pretty, this.eol);
    }

    public ObjectMapperFactory withModule(Module module) {
        return this.withModules(module);
    }

    public ObjectMapperFactory withModules(Module ... modules) {
        ObjectMapperFactory factory = new ObjectMapperFactory(this.modules, this.pretty, this.eol);
        factory.modules.addAll(Arrays.asList(modules));
        return factory;
    }

    public ObjectMapper create() {
        ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().typeFactory(TypeFactory.defaultInstance().withClassLoader(this.getClass().getClassLoader()))).serializationInclusion(JsonInclude.Include.NON_ABSENT)).defaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_ABSENT, (JsonInclude.Include)JsonInclude.Include.NON_ABSENT))).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).enable(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS})).enable(new SerializationFeature[]{SerializationFeature.CLOSE_CLOSEABLE})).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).configure(SerializationFeature.INDENT_OUTPUT, this.pretty)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
        if (this.pretty) {
            DefaultIndenter indent = new DefaultIndenter("  ", this.eol);
            mapper.writer((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)indent).withArrayIndenter((DefaultPrettyPrinter.Indenter)indent));
        }
        for (Module module : this.modules) {
            mapper.registerModule(module);
        }
        return mapper;
    }

    public String toString() {
        return "ObjectMapperFactory{pretty=" + this.pretty + ", modules=" + this.modules + '}';
    }
}

