/*
 * Decompiled with CFR 0.152.
 */
package com.tc.statistics;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StatisticData
implements Serializable {
    public static final StatisticData[] EMPTY_ARRAY = new StatisticData[0];
    private static final long serialVersionUID = -3387790670840965825L;
    private String sessionId;
    private String agentIp;
    private String agentDifferentiator;
    private Date moment;
    private String name;
    private String element;
    private Object data;

    public StatisticData() {
    }

    public StatisticData(String name, Long value) {
        this.setName(name);
        this.setData(value);
    }

    public StatisticData(String name, String value) {
        this.setName(name);
        this.setData(value);
    }

    public StatisticData(String name, Date value) {
        this.setName(name);
        this.setData(value);
    }

    public StatisticData(String name, BigDecimal value) {
        this.setName(name);
        this.setData(value);
    }

    public StatisticData(String name, String element, Long value) {
        this.setName(name);
        this.setElement(element);
        this.setData(value);
    }

    public StatisticData(String name, String element, String value) {
        this.setName(name);
        this.setElement(element);
        this.setData(value);
    }

    public StatisticData(String name, String element, Date value) {
        this.setName(name);
        this.setElement(element);
        this.setData(value);
    }

    public StatisticData(String name, String element, BigDecimal value) {
        this.setName(name);
        this.setElement(element);
        this.setData(value);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public StatisticData sessionId(String sessionID) {
        this.setSessionId(sessionID);
        return this;
    }

    public String getAgentIp() {
        return this.agentIp;
    }

    public void setAgentIp(String agentIp) {
        this.agentIp = agentIp;
    }

    public StatisticData agentIp(String agentIP) {
        this.setAgentIp(agentIP);
        return this;
    }

    public String getAgentDifferentiator() {
        return this.agentDifferentiator;
    }

    public StatisticData agentDifferentiator(String agentDiff) {
        this.setAgentDifferentiator(agentDiff);
        return this;
    }

    public void setAgentDifferentiator(String agentDifferentiator) {
        this.agentDifferentiator = agentDifferentiator;
    }

    public void setMoment(Date moment) {
        this.moment = moment;
    }

    public StatisticData moment(Date date) {
        this.setMoment(date);
        return this;
    }

    public Date getMoment() {
        return this.moment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StatisticData name(String nameArg) {
        this.setName(nameArg);
        return this;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public StatisticData element(String elementArg) {
        this.setElement(elementArg);
        return this;
    }

    public Object getData() {
        return this.data;
    }

    private void setData(Object data) {
        this.data = data;
    }

    private StatisticData data(Object obj) {
        this.setData(obj);
        return this;
    }

    public void setData(Long data) {
        this.setData((Object)data);
    }

    public StatisticData data(Long longData) {
        return this.data((Object)longData);
    }

    public void setData(String data) {
        this.setData((Object)data);
    }

    public StatisticData data(String strData) {
        return this.data((Object)strData);
    }

    public void setData(Date data) {
        this.setData((Object)data);
    }

    public StatisticData data(Date dateData) {
        return this.data((Object)dateData);
    }

    public void setData(BigDecimal data) {
        this.setData((Object)data);
    }

    public StatisticData data(BigDecimal bigDecimalData) {
        return this.data((Object)bigDecimalData);
    }

    public Object clone() {
        return new StatisticData().sessionId(this.sessionId).agentIp(this.agentIp).agentDifferentiator(this.agentDifferentiator).moment(this.moment).name(this.name).element(this.element).data(this.data);
    }

    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss SSS");
        String data_formatted = this.data != null && this.data instanceof Date ? format.format(this.data) : String.valueOf(this.data);
        return "[sessionId = " + this.sessionId + "; " + "agentIp = " + this.agentIp + "; " + "agentDifferentiator = " + this.agentDifferentiator + "; " + "moment = " + (null == this.moment ? String.valueOf(this.moment) : format.format(this.moment)) + "; " + "name = " + this.name + "; " + "element = " + this.element + "; " + "data = " + data_formatted + "" + "]";
    }

    public String toLog() {
        String data_formatted;
        if (this.data != null && this.data instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss SSS");
            data_formatted = format.format(this.data);
        } else {
            data_formatted = String.valueOf(this.data);
        }
        return this.name + (null == this.element ? "" : " - " + this.element) + " : " + data_formatted;
    }

    public static String escapeForCsv(String value) {
        char[] chars = value.toCharArray();
        StringBuffer buffer = null;
        int last = 0;
        String replacement = null;
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\\': {
                    replacement = "\\\\";
                    break;
                }
                case '\"': {
                    replacement = "\\\"";
                    break;
                }
                case '\r': {
                    replacement = "";
                    break;
                }
                case '\n': {
                    replacement = "\\n";
                }
            }
            if (replacement == null) continue;
            if (null == buffer) {
                buffer = new StringBuffer();
            }
            if (last < i) {
                buffer.append(chars, last, i - last);
            }
            buffer.append(replacement);
            replacement = null;
            last = i + 1;
        }
        if (null == buffer) {
            return value;
        }
        if (last < value.length()) {
            buffer.append(chars, last, value.length() - last);
        }
        return buffer.toString();
    }

    private static void addCsvField(StringBuffer result, Object field, boolean separator) {
        if (null == field) {
            if (separator) {
                result.append(",");
            }
        } else {
            result.append("\"");
            result.append(StatisticData.escapeForCsv(String.valueOf(field)));
            result.append("\"");
            if (separator) {
                result.append(",");
            }
        }
    }

    public String toCsv() {
        StringBuffer result = new StringBuffer();
        StatisticData.addCsvField(result, this.sessionId, true);
        StatisticData.addCsvField(result, this.agentIp, true);
        StatisticData.addCsvField(result, this.agentDifferentiator, true);
        StatisticData.addCsvField(result, null == this.moment ? null : new Long(this.moment.getTime()), true);
        StatisticData.addCsvField(result, this.name, true);
        StatisticData.addCsvField(result, this.element, true);
        if (null == this.data) {
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, false);
        } else if (this.data instanceof BigDecimal) {
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, this.data, false);
        } else if (this.data instanceof Number) {
            StatisticData.addCsvField(result, this.data, true);
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, false);
        } else if (this.data instanceof CharSequence) {
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, this.data, true);
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, false);
        } else if (this.data instanceof Date) {
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null, true);
            StatisticData.addCsvField(result, null == this.data ? null : new Long(((Date)this.data).getTime()), true);
            StatisticData.addCsvField(result, null, false);
        }
        result.append("\n");
        return result.toString();
    }

    public String toXml() {
        StringBuffer result = new StringBuffer();
        result.append("<sessionId>");
        if (this.sessionId != null) {
            result.append(this.sessionId);
        }
        result.append("</sessionId>");
        result.append("<agentIp>");
        if (this.agentIp != null) {
            result.append(this.agentIp);
        }
        result.append("</agentIp>");
        result.append("<agentDifferentiator>");
        if (this.agentDifferentiator != null) {
            result.append(this.agentDifferentiator);
        }
        result.append("</agentDifferentiator>");
        result.append("<moment>");
        if (this.moment != null) {
            result.append(new Long(this.moment.getTime()));
        }
        result.append("</moment>");
        result.append("<name>");
        if (this.name != null) {
            result.append(this.name);
        }
        result.append("</name>");
        result.append("<element>");
        if (this.element != null) {
            result.append(this.element);
        }
        result.append("</element>");
        result.append("<value>");
        if (this.data != null) {
            if (this.data instanceof Date) {
                result.append(new Long(((Date)this.data).getTime()));
            } else {
                result.append(this.data);
            }
        }
        result.append("</value>");
        return result.toString();
    }
}

