/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.ClassReader;
import com.tc.asm.ClassVisitor;
import com.tc.asm.FieldVisitor;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.asm.Type;
import com.tc.asm.commons.LocalVariablesSorter;
import com.tc.asm.tree.ClassNode;
import com.tc.asm.tree.MethodNode;
import com.tc.object.bytecode.ClassAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DelegateMethodAdapter
extends ClassVisitor
implements Opcodes,
ClassAdapterFactory {
    private final Map overrideMethods;
    private final String delegateFieldName;
    private final String delegateType;
    private final boolean delegateIsInterface;
    private final boolean crossLoader;
    private String delegateFieldType;
    private String thisClassname;
    private boolean helperInjected;

    private DelegateMethodAdapter(ClassVisitor cv, Class superClass, String delegateFieldName, boolean crossLoader) {
        super(327680, cv);
        this.delegateFieldName = delegateFieldName;
        this.crossLoader = crossLoader;
        this.overrideMethods = DelegateMethodAdapter.getOverrideMethods(superClass);
        this.delegateType = superClass.getName().replace('.', '/');
        this.delegateIsInterface = superClass.isInterface();
    }

    public DelegateMethodAdapter(String delegateType, String delegateField) {
        super(327680, null);
        this.delegateFieldName = delegateField;
        this.delegateType = delegateType;
        this.overrideMethods = null;
        this.delegateIsInterface = false;
        this.crossLoader = false;
    }

    public ClassVisitor create(ClassVisitor visitor, ClassLoader loader) {
        Class<?> delegateClass;
        try {
            delegateClass = Class.forName(this.delegateType, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class " + this.delegateType);
        }
        return new DelegateMethodAdapter(visitor, delegateClass, this.delegateFieldName, delegateClass.getClassLoader() != loader);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.thisClassname = name;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.delegateFieldName.equals(name)) {
            if (this.delegateFieldType != null) {
                throw new AssertionError((Object)("field type already set: " + this.delegateFieldType));
            }
            this.delegateFieldType = desc;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String sig = name + Type.getMethodDescriptor(Type.getReturnType(desc), Type.getArgumentTypes(desc));
        if (!Modifier.isPublic(access) && !Modifier.isPrivate(access) && !Modifier.isStatic(access) && this.crossLoader) {
            throw new AssertionError((Object)("cross loader protected/package-private method present in original class: " + this.thisClassname + ", " + sig));
        }
        this.overrideMethods.remove(sig);
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        for (Method method : this.overrideMethods.values()) {
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            String[] exceptions = new String[exceptionTypes.length];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = exceptionTypes[i].getName().replace('.', '/');
            }
            Type[] argumentTypes = Type.getArgumentTypes(method);
            boolean normalBody = true;
            int access = method.getModifiers();
            if (!Modifier.isPublic(access &= 0xFFFFFBFF) && !Modifier.isPrivate(access) && this.crossLoader) {
                if (Modifier.isProtected(access)) {
                    normalBody = false;
                    access = 1;
                } else {
                    throw new AssertionError((Object)("Package private method cannot be delegated cross-loader: " + method));
                }
            }
            String desc = Type.getMethodDescriptor(method);
            LocalVariablesSorter mv = new LocalVariablesSorter(access, desc, super.visitMethod(access, method.getName(), desc, null, exceptions));
            mv.visitCode();
            if (normalBody) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.thisClassname, this.delegateFieldName, this.delegateFieldType);
                int slot = 1;
                for (Type arg : argumentTypes) {
                    mv.visitVarInsn(arg.getOpcode(21), slot);
                    slot += arg.getSize();
                }
                mv.visitMethodInsn(this.delegateIsInterface ? 185 : 182, this.delegateType, method.getName(), Type.getMethodDescriptor(method), this.delegateIsInterface);
                Type returnType = Type.getReturnType(method);
                if (returnType == Type.VOID_TYPE) {
                    mv.visitInsn(177);
                } else {
                    mv.visitInsn(returnType.getOpcode(172));
                }
            } else {
                this.injectHelper();
                this.reflectiveBody(mv, method, argumentTypes);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    private void reflectiveBody(LocalVariablesSorter mv, Method m, Type[] argumentTypes) {
        int indexSlot = mv.newLocal(Type.INT_TYPE);
        int argTypesSlot = mv.newLocal(Type.getType(String[].class));
        int argsSlot = mv.newLocal(Type.getType(Object[].class));
        int numParams = m.getParameterTypes().length;
        mv.visitInsn(3);
        mv.visitVarInsn(54, indexSlot);
        mv.visitLdcInsn(new Integer(numParams));
        mv.visitTypeInsn(189, "java/lang/String");
        mv.visitVarInsn(58, argTypesSlot);
        mv.visitLdcInsn(new Integer(numParams));
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitVarInsn(58, argsSlot);
        for (Class<?> argType : m.getParameterTypes()) {
            mv.visitVarInsn(25, argTypesSlot);
            mv.visitVarInsn(21, indexSlot);
            mv.visitIincInsn(indexSlot, 1);
            mv.visitLdcInsn(argType.getName());
            mv.visitInsn(83);
        }
        mv.visitInsn(3);
        mv.visitVarInsn(54, indexSlot);
        int paramSlot = 1;
        for (int i = 0; i < numParams; ++i) {
            mv.visitVarInsn(25, argsSlot);
            mv.visitVarInsn(21, indexSlot);
            mv.visitIincInsn(indexSlot, 1);
            mv.visitVarInsn(argumentTypes[i].getOpcode(21), paramSlot);
            paramSlot += argumentTypes[i].getSize();
            switch (argumentTypes[i].getSort()) {
                case 1: {
                    mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 8: {
                    mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
                case 6: {
                    mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 5: {
                    mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 7: {
                    mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 4: {
                    mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                }
            }
            mv.visitInsn(83);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.thisClassname, this.delegateFieldName, this.delegateFieldType);
        mv.visitLdcInsn(m.getName());
        mv.visitVarInsn(25, argTypesSlot);
        mv.visitVarInsn(25, argsSlot);
        mv.visitMethodInsn(184, this.thisClassname, "__tc_reflectiveInvoke", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", false);
        Type returnType = Type.getReturnType(m);
        if (returnType == Type.VOID_TYPE) {
            mv.visitInsn(177);
        } else {
            switch (returnType.getSort()) {
                case 1: {
                    mv.visitTypeInsn(192, "java/lang/Boolean");
                    mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                    break;
                }
                case 3: {
                    mv.visitTypeInsn(192, "java/lang/Byte");
                    mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                    break;
                }
                case 2: {
                    mv.visitTypeInsn(192, "java/lang/Character");
                    mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                    break;
                }
                case 8: {
                    mv.visitTypeInsn(192, "java/lang/Double");
                    mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                    break;
                }
                case 6: {
                    mv.visitTypeInsn(192, "java/lang/Float");
                    mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                    break;
                }
                case 5: {
                    mv.visitTypeInsn(192, "java/lang/Integer");
                    mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                    break;
                }
                case 7: {
                    mv.visitTypeInsn(192, "java/lang/Long");
                    mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                    break;
                }
                case 4: {
                    mv.visitTypeInsn(192, "java/lang/Short");
                    mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                    break;
                }
                default: {
                    mv.visitTypeInsn(192, returnType.getInternalName());
                }
            }
            mv.visitInsn(returnType.getOpcode(172));
        }
    }

    private void injectHelper() {
        if (this.helperInjected) {
            return;
        }
        this.helperInjected = true;
        this.inject("reflectiveInvoke");
    }

    private void inject(String methodName) {
        MethodNode mn = this.getMethodNode(methodName);
        mn.name = "__tc_" + methodName;
        mn.access = 4106;
        mn.accept(this);
    }

    private MethodNode getMethodNode(String methodName) {
        try {
            String res = this.getClass().getName().replace('.', '/').concat(".class");
            ClassReader reader = new ClassReader(this.getClass().getClassLoader().getResourceAsStream(res));
            ClassNode classNode = new ClassNode();
            reader.accept(classNode, 0);
            for (MethodNode mn : classNode.methods) {
                if (!mn.name.equals(methodName)) continue;
                return mn;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new NoSuchMethodError(methodName);
    }

    static Object reflectiveInvoke(Object o, String name, String[] argTypes, Object[] args) {
        Method method = null;
        for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (!m.getName().equals(name) || (parameterTypes = m.getParameterTypes()).length != argTypes.length) continue;
                boolean match = true;
                for (int i = 0; i < argTypes.length; ++i) {
                    if (argTypes[i].equals(parameterTypes[i].getName())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                method = m;
            }
        }
        if (method == null) {
            throw new RuntimeException("No such method " + name + Arrays.asList(argTypes));
        }
        method.setAccessible(true);
        try {
            return method.invoke(o, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map getOverrideMethods(Class c) {
        HashMap<String, Method> rv = new HashMap<String, Method>();
        while (c != null && c != Object.class) {
            Method[] methods;
            for (Method m : methods = c.isInterface() ? c.getMethods() : c.getDeclaredMethods()) {
                int access = m.getModifiers();
                if (m.getName().startsWith("__tc_") || Modifier.isStatic(access) || Modifier.isPrivate(access)) continue;
                if (Modifier.isFinal(access)) {
                    throw new AssertionError((Object)("Final modifier found (must be be removed): " + m.toString()));
                }
                String sig = m.getName() + Type.getMethodDescriptor(m);
                rv.put(sig, m);
            }
            c = c.getSuperclass();
        }
        return rv;
    }
}

