/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.configuration;

import com.tc.bundles.BundleSpecUtil;
import com.tc.logging.TCLogger;
import com.tc.object.config.ClassReplacementTest;
import com.tc.object.config.LockDefinition;
import com.tc.object.config.StandardDSOClientConfigHelper;
import com.tc.object.config.TransparencyClassSpec;
import com.tc.properties.TCProperties;
import java.net.MalformedURLException;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public abstract class TerracottaConfiguratorModule
implements BundleActivator {
    protected StandardDSOClientConfigHelper configHelper;
    private TCLogger logger;
    private Bundle thisBundle;
    private TCProperties tcProps;

    protected ServiceReference getConfigHelperReference(BundleContext context) throws Exception {
        String CONFIGHELPER_CLASS_NAME = StandardDSOClientConfigHelper.class.getName();
        ServiceReference configHelperRef = context.getServiceReference(CONFIGHELPER_CLASS_NAME);
        if (configHelperRef == null) {
            throw new BundleException("Expected the " + CONFIGHELPER_CLASS_NAME + " service to be registered, was unable to find it");
        }
        return configHelperRef;
    }

    public final void start(BundleContext context) throws Exception {
        this.thisBundle = context.getBundle();
        this.logger = (TCLogger)context.getService(context.getServiceReference(TCLogger.class.getName()));
        if (this.logger == null) {
            throw new BundleException("missing logger reference for " + this.thisBundle.getSymbolicName());
        }
        this.tcProps = (TCProperties)context.getService(context.getServiceReference(TCProperties.class.getName()));
        if (this.tcProps == null) {
            throw new BundleException("missing tc-properties reference for " + this.thisBundle.getSymbolicName());
        }
        ServiceReference configHelperRef = this.getConfigHelperReference(context);
        this.configHelper = (StandardDSOClientConfigHelper)context.getService(configHelperRef);
        if (this.configHelper == null) {
            throw new AssertionError((Object)"configHelper is null");
        }
        this.addInstrumentation(context);
        context.ungetService(configHelperRef);
        this.registerModuleSpec(context);
        if (!Boolean.getBoolean("tc.bootjar.creation")) {
            this.registerMBeanSpec(context);
            this.registerSRASpec(context);
        }
    }

    protected Bundle getThisBundle() {
        return this.thisBundle;
    }

    protected TCProperties getTcProps() {
        return this.tcProps;
    }

    protected TCLogger getLogger() {
        return this.logger;
    }

    public void stop(BundleContext context) throws Exception {
    }

    protected void addInstrumentation(BundleContext context) {
    }

    protected void registerModuleSpec(BundleContext context) {
    }

    protected void registerMBeanSpec(BundleContext context) {
    }

    protected void registerSRASpec(BundleContext context) {
    }

    protected final void addClassReplacement(Bundle bundle, String originalClassName, String replacementClassName) {
        this.addClassReplacement(bundle, originalClassName, replacementClassName, null);
    }

    protected final void addClassReplacement(Bundle bundle, String originalClassName, String replacementClassName, ClassReplacementTest test) {
        URL resource = this.getBundleResourceURL(bundle, TerracottaConfiguratorModule.classNameToFileName(replacementClassName));
        this.configHelper.addClassReplacement(originalClassName, replacementClassName, resource, test);
    }

    private URL getBundleResourceURL(Bundle bundle, String resourceName) {
        URL bundleURL = this.configHelper.getBundleURL(bundle);
        if (bundleURL == null) {
            throw new RuntimeException(bundle.getLocation() + " was not loaded with this config");
        }
        try {
            if (bundleURL.getProtocol().equals("file") && bundleURL.getPath().endsWith(".jar")) {
                return new URL("jar:" + bundleURL.toExternalForm() + "!/" + resourceName);
            }
            String base = bundleURL.toExternalForm();
            if (!base.endsWith("/")) {
                base = base + "/";
            }
            return new URL(bundleURL, base + resourceName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot create URL for " + resourceName, e);
        }
    }

    protected final void addExportedBundleClass(Bundle bundle, String classname, boolean targetSystemLoaderOnly) {
        URL url = this.getBundleResourceURL(bundle, TerracottaConfiguratorModule.classNameToFileName(classname));
        this.configHelper.addClassResource(classname, url, targetSystemLoaderOnly);
    }

    protected final void addExportedBundleClass(Bundle bundle, String classname) {
        this.addExportedBundleClass(bundle, classname, false);
    }

    protected final void addExportedTcJarClass(String classname) {
        URL resource = TerracottaConfiguratorModule.class.getClassLoader().getResource(TerracottaConfiguratorModule.classNameToFileName(classname));
        if (resource == null) {
            throw new RuntimeException("Exported TC jar class " + classname + " does not exist.");
        }
        this.configHelper.addClassResource(classname, resource, false);
    }

    protected TransparencyClassSpec getOrCreateSpec(String expr, boolean markAsPreInstrumented) {
        TransparencyClassSpec spec = this.configHelper.getOrCreateSpec(expr);
        if (markAsPreInstrumented) {
            spec.markPreInstrumented();
        }
        return spec;
    }

    protected TransparencyClassSpec getOrCreateSpec(String expr) {
        return this.getOrCreateSpec(expr, true);
    }

    protected void addLock(String expr, LockDefinition ld) {
        this.configHelper.addLock(expr, ld);
    }

    protected Bundle getExportedBundle(BundleContext context, String targetBundleName) {
        for (Bundle bundle : context.getBundles()) {
            if (!BundleSpecUtil.isMatchingSymbolicName(targetBundleName, bundle.getSymbolicName())) continue;
            return bundle;
        }
        return null;
    }

    private static final String classNameToFileName(String className) {
        return className.replace('.', '/') + ".class";
    }
}

