/*
 * Decompiled with CFR 0.152.
 */
package com.tc.statistics;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatisticType {
    private static final Map<String, StatisticType> TYPES = new ConcurrentHashMap<String, StatisticType>();
    public static final StatisticType STARTUP = new StatisticType("STARTUP");
    public static final StatisticType SNAPSHOT = new StatisticType("SNAPSHOT");
    public static final StatisticType TRIGGERED = new StatisticType("TRIGGERED");
    private final String identifier;

    private StatisticType(String identifier) {
        if (identifier == null) {
            throw new AssertionError((Object)"identifier is null");
        }
        this.identifier = identifier;
        TYPES.put(identifier, this);
    }

    public static StatisticType getType(String identifier) {
        if (null == identifier) {
            return null;
        }
        return TYPES.get(identifier.toUpperCase());
    }

    public static Collection getAllTypes() {
        return Collections.unmodifiableCollection(TYPES.values());
    }

    public String toString() {
        return this.identifier;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        return object instanceof StatisticType && ((StatisticType)object).identifier.equals(this.identifier);
    }
}

