/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class OverrideCheck {
    public static void check(Class parent, Class subClass) {
        boolean excludeSuper = parent.isAssignableFrom(subClass);
        Set superMethods = OverrideCheck.methodsFor(parent, false);
        Set subMethods = OverrideCheck.methodsFor(subClass, excludeSuper);
        ArrayList<String> missing = new ArrayList<String>();
        for (String method : superMethods) {
            if (subMethods.contains(method)) continue;
            missing.add(method);
        }
        if (!missing.isEmpty()) {
            throw new RuntimeException("Missing overrides:\n" + missing);
        }
    }

    private static Set methodsFor(Class c, boolean excludeSuper) {
        HashSet<String> set = new HashSet<String>();
        while (c != null && c != Object.class) {
            Method[] methods;
            for (Method m : methods = c.isInterface() ? c.getMethods() : c.getDeclaredMethods()) {
                int access = m.getModifiers();
                if (Modifier.isStatic(access) || Modifier.isPrivate(access) || m.getName().startsWith("__tc_")) continue;
                StringBuffer sig = new StringBuffer();
                sig.append(m.getName()).append('(');
                Class<?>[] parameterTypes = m.getParameterTypes();
                for (int j = 0; j < parameterTypes.length; ++j) {
                    sig.append(parameterTypes[j].getName());
                    if (j >= parameterTypes.length - 1) continue;
                    sig.append(',');
                }
                sig.append(')');
                set.add(sig.toString());
            }
            if (excludeSuper) {
                return set;
            }
            c = c.getSuperclass();
        }
        return set;
    }
}

