/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.applicator;

import com.tc.logging.TCLogger;
import com.tc.object.LiteralValues;
import com.tc.object.ObjectID;
import com.tc.object.TCObjectExternal;
import com.tc.object.applicator.ApplicatorObjectManager;
import com.tc.object.applicator.ChangeApplicator;
import com.tc.object.dna.api.DNAEncoding;

public abstract class BaseApplicator
implements ChangeApplicator {
    protected final DNAEncoding encoding;
    private final TCLogger logger;

    protected BaseApplicator(DNAEncoding encoding, TCLogger logger) {
        this.encoding = encoding;
        this.logger = logger;
    }

    protected TCLogger getLogger() {
        return this.logger;
    }

    protected final Object getDehydratableObject(Object pojo, ApplicatorObjectManager objectManager) {
        if (pojo == null) {
            return ObjectID.NULL_ID;
        }
        if (LiteralValues.isLiteralInstance(pojo)) {
            return pojo;
        }
        TCObjectExternal tcObject = objectManager.lookupExistingOrNull(pojo);
        if (tcObject == null) {
            this.logger.warn("Not dehydrating object of type " + pojo.getClass().getName() + "@" + System.identityHashCode(pojo));
            return null;
        }
        return tcObject.getObjectID();
    }

    protected final boolean isLiteralInstance(Object pojo) {
        return LiteralValues.isLiteralInstance(pojo);
    }

    protected boolean isPortableReference(Class c) {
        return !LiteralValues.isLiteral(c.getName());
    }
}

