/*
 * Decompiled with CFR 0.152.
 */
package com.tc.backport175.proxy;

import com.tc.asm.Type;
import com.tc.backport175.bytecode.AnnotationElement;
import com.tc.backport175.bytecode.AnnotationReader;
import com.tc.backport175.proxy.ProxyFactory;
import com.tc.backport175.proxy.ResolveAnnotationException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JavaDocAnnotationInvocationHander
implements InvocationHandler,
Serializable {
    static final long serialVersionUID = 1584167345753299421L;
    private static final String TO_STRING_METHOD_NAME = "toString";
    private static final String ANNOTATION_TYPE_METHOD_NAME = "annotationType";
    private final Class m_annotationInterface;
    private final AnnotationElement.Annotation m_annotation;
    private final String m_annotationName;
    private final ClassLoader m_annotatedClassClassLoader;

    private ClassLoader getAnnotatedClassClassLoader() {
        return this.m_annotatedClassClassLoader;
    }

    public JavaDocAnnotationInvocationHander(Class annotationInterface, AnnotationElement.Annotation annotation, ClassLoader annotatedClassClassLoader) {
        this.m_annotationInterface = annotationInterface;
        this.m_annotation = annotation;
        this.m_annotationName = annotationInterface.getName().replace('/', '.');
        this.m_annotatedClassClassLoader = annotatedClassClassLoader != null ? annotatedClassClassLoader : ClassLoader.getSystemClassLoader();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals(ANNOTATION_TYPE_METHOD_NAME)) {
            return this.m_annotationInterface;
        }
        if (methodName.equals(TO_STRING_METHOD_NAME)) {
            return this.invokeToString();
        }
        return this.invokeAnnotationValue(method);
    }

    private Object invokeAnnotationValue(Method method) {
        Object returnValue = null;
        for (AnnotationElement.NamedValue namedValue : this.m_annotation.getElements()) {
            if (!namedValue.getName().equals(method.getName())) continue;
            returnValue = this.resolveValue(namedValue, method.getReturnType());
            break;
        }
        return returnValue;
    }

    private Object invokeToString() {
        StringBuffer sb = new StringBuffer();
        sb.append('@');
        sb.append(this.m_annotationName);
        sb.append('(');
        sb.append(this.m_annotation.toString());
        sb.append(')');
        return sb.toString();
    }

    private Object resolveValue(AnnotationElement.NamedValue namedValue, Class valueType) {
        Object value;
        if (namedValue.isResolved()) {
            return namedValue.getResolvedValue();
        }
        AnnotationElement.Type type = namedValue.getType();
        if (type.equals(AnnotationElement.Type.ANNOTATION)) {
            AnnotationElement.Annotation annotation = (AnnotationElement.Annotation)namedValue.getValue();
            value = ProxyFactory.newAnnotationProxy(annotation, this.getAnnotatedClassClassLoader());
        } else {
            value = type.equals(AnnotationElement.Type.ARRAY) ? this.resolveArray(namedValue, valueType) : (type.equals(AnnotationElement.Type.ENUM) ? this.resolveEnum(namedValue) : (type.equals(AnnotationElement.Type.TYPE) ? this.resolveType(namedValue) : namedValue.getValue()));
        }
        namedValue.setResolvedValue(value);
        return value;
    }

    private Object resolveType(AnnotationElement.NamedValue namedValue) {
        Object value = namedValue.getValue();
        if (value instanceof Type) {
            Class<?> resolvedType;
            Type type = (Type)value;
            try {
                if (type.getClassName().endsWith("[]")) {
                    int dimensions = type.getDimensions();
                    Type elementType = type.getElementType();
                    Class componentType = this.resolveType(elementType);
                    resolvedType = Array.newInstance(componentType, new int[dimensions]).getClass();
                } else {
                    resolvedType = this.resolveType(type);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ResolveAnnotationException("class [" + type.getClassName() + "] defined in annotation can not be found in class loader [" + this.m_annotatedClassClassLoader + "]", cnfe);
            }
            return resolvedType;
        }
        return value;
    }

    private Class resolveType(Type type) throws ClassNotFoundException {
        Class<Comparable<Long>> resolvedType = Type.LONG_TYPE.equals(type) ? Long.TYPE : (Type.INT_TYPE.equals(type) ? Integer.TYPE : (Type.SHORT_TYPE.equals(type) ? Short.TYPE : (Type.DOUBLE_TYPE.equals(type) ? Double.TYPE : (Type.FLOAT_TYPE.equals(type) ? Float.TYPE : (Type.BOOLEAN_TYPE.equals(type) ? Boolean.TYPE : (Type.BYTE_TYPE.equals(type) ? Byte.TYPE : (Type.CHAR_TYPE.equals(type) ? Character.TYPE : Class.forName(type.getClassName(), false, this.getAnnotatedClassClassLoader()))))))));
        return resolvedType;
    }

    private Object resolveEnum(AnnotationElement.NamedValue namedValue) {
        AnnotationElement.Enum enumElement = (AnnotationElement.Enum)namedValue.getValue();
        String className = AnnotationReader.toJavaName(enumElement.getDesc());
        String value = enumElement.getValue();
        try {
            Class<?> clazz = Class.forName(className, false, this.getAnnotatedClassClassLoader());
            Field field = clazz.getDeclaredField(value);
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ResolveAnnotationException("can not access static reference field due to: " + e.toString(), e);
            }
        }
        catch (Exception e) {
            throw new ResolveAnnotationException("could not retrieve static reference to field (enum) [" + className + "." + namedValue.getName() + "] due to: " + e.toString(), e);
        }
    }

    private Object resolveArray(AnnotationElement.NamedValue namedValue, Class valueType) {
        Object[] arrayInstance;
        if (!valueType.isArray()) {
            throw new IllegalArgumentException("annotation interface method [" + namedValue.getName() + "] in interface [" + this.m_annotationName + "] needs to return an ARRAY type");
        }
        AnnotationElement.Array array = (AnnotationElement.Array)namedValue.getValue();
        Class<?> componentType = valueType.getComponentType();
        List arrayElements = array.getElements();
        ArrayList<Object> elementList = new ArrayList<Object>();
        for (AnnotationElement.NamedValue arrayValue : arrayElements) {
            elementList.add(this.resolveValue(arrayValue, componentType));
        }
        if (componentType.isPrimitive()) {
            if (componentType.equals(Integer.TYPE)) {
                arrayInstance = (int[])Array.newInstance(componentType, arrayElements.size());
                int i = 0;
                for (Integer n : elementList) {
                    arrayInstance[i++] = n;
                }
                return arrayInstance;
            }
            if (componentType.equals(Long.TYPE)) {
                arrayInstance = (long[])Array.newInstance(componentType, arrayElements.size());
                int i = 0;
                for (Long l : elementList) {
                    arrayInstance[i++] = l;
                }
                return arrayInstance;
            }
            if (componentType.equals(Short.TYPE)) {
                arrayInstance = (short[])Array.newInstance(componentType, arrayElements.size());
                int i = 0;
                for (Short s : elementList) {
                    arrayInstance[i++] = s;
                }
                return arrayInstance;
            }
            if (componentType.equals(Float.TYPE)) {
                arrayInstance = (float[])Array.newInstance(componentType, arrayElements.size());
                int i = 0;
                for (Float f : elementList) {
                    arrayInstance[i++] = f.floatValue();
                }
                return arrayInstance;
            }
            if (componentType.equals(Double.TYPE)) {
                arrayInstance = (double[])Array.newInstance(componentType, arrayElements.size());
                int i = 0;
                for (Double d : elementList) {
                    arrayInstance[i++] = d;
                }
                return arrayInstance;
            }
            if (componentType.equals(Character.TYPE)) {
                arrayInstance = (char[])Array.newInstance(componentType, arrayElements.size());
                int i = 0;
                for (Character c : elementList) {
                    arrayInstance[i++] = c.charValue();
                }
                return arrayInstance;
            }
            if (componentType.equals(Boolean.TYPE)) {
                arrayInstance = (boolean[])Array.newInstance(componentType, arrayElements.size());
                int i = 0;
                for (Boolean bl : elementList) {
                    arrayInstance[i++] = bl;
                }
                return arrayInstance;
            }
            if (componentType.equals(Byte.TYPE)) {
                arrayInstance = (byte[])Array.newInstance(componentType, arrayElements.size());
                int i = 0;
                for (Byte by : elementList) {
                    arrayInstance[i++] = by;
                }
                return arrayInstance;
            }
        } else {
            arrayInstance = (Object[])Array.newInstance(componentType, arrayElements.size());
            int i = 0;
            for (Object e : elementList) {
                arrayInstance[i++] = e;
            }
            return arrayInstance;
        }
        return null;
    }
}

