/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.version;

import com.tc.util.version.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class VersionRange {
    static final String VERSION_PATTERN_STR = "(\\d+(?:\\.\\d+(?:\\.\\d+(?:-\\w+)?)?)?)";
    private static final Pattern VERSION = Pattern.compile("^([(\\[])?(\\d+(?:\\.\\d+(?:\\.\\d+(?:-\\w+)?)?)?)(?:,(\\d+(?:\\.\\d+(?:\\.\\d+(?:-\\w+)?)?)?)([\\])])?)?$");
    private final String minVersion;
    private final String maxVersion;
    private final boolean minIsInclusive;
    private final boolean maxIsInclusive;

    public VersionRange(String versionString) {
        Matcher m = VERSION.matcher(versionString);
        if (m.matches()) {
            if (m.groupCount() != 4) {
                throw new IllegalArgumentException("Unknown version string: " + versionString);
            }
        } else {
            throw new IllegalArgumentException("Unknown version string: " + versionString);
        }
        this.minIsInclusive = m.group(1) != null ? m.group(1).equals("[") : true;
        this.minVersion = m.group(2);
        this.maxVersion = m.group(3) != null ? m.group(3) : this.minVersion;
        this.maxIsInclusive = m.group(4) != null ? m.group(4).equals("]") : true;
    }

    public VersionRange(String minVersion, String maxVersion) {
        this(minVersion, maxVersion, true, false);
    }

    public VersionRange(String minVersion, String maxVersion, boolean minIsInclusive, boolean maxIsInclusive) {
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.minIsInclusive = minIsInclusive;
        this.maxIsInclusive = maxIsInclusive;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public boolean isMinInclusive() {
        return this.minIsInclusive;
    }

    public boolean isMaxInclusive() {
        return this.maxIsInclusive;
    }

    public boolean contains(String otherVersionStr) {
        Version otherVersion = new Version(otherVersionStr);
        Version min = new Version(this.minVersion);
        Version max = new Version(this.maxVersion);
        int compareMin = otherVersion.compareTo(min);
        int compareMax = otherVersion.compareTo(max);
        boolean greaterThanMin = compareMin > 0 || this.isMinInclusive() && compareMin == 0;
        boolean lessThanMax = compareMax < 0 || this.isMaxInclusive() && compareMax == 0;
        return greaterThanMin && lessThanMax;
    }
}

