/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.version;

import com.tc.util.version.VersionRange;

public class VersionMatcher {
    public static final String ANY_VERSION = "*";
    private final String tcVersion;
    private final String apiVersion;

    public VersionMatcher(String tcVersion, String apiVersion) {
        if (tcVersion == null || tcVersion.equals(ANY_VERSION)) {
            throw new IllegalArgumentException("Invalid tcVersion: " + tcVersion);
        }
        if (apiVersion == null || apiVersion.equals(ANY_VERSION)) {
            throw new IllegalArgumentException("Invalid apiVersion: " + apiVersion);
        }
        this.tcVersion = tcVersion;
        this.apiVersion = apiVersion;
    }

    public boolean matches(String moduleTcVersion, String moduleApiVersion) {
        return this.tcMatches(moduleTcVersion) && this.apiMatches(moduleApiVersion);
    }

    private boolean tcMatches(String moduleTcVersion) {
        return ANY_VERSION.equals(moduleTcVersion) || this.tcVersion.equals(moduleTcVersion);
    }

    private boolean apiMatches(String moduleApiVersion) {
        if (ANY_VERSION.equals(moduleApiVersion)) {
            return true;
        }
        return new VersionRange(moduleApiVersion).contains(this.apiVersion);
    }
}

