/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(?:-(\\w+))?)?)?$");
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public Version(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        if (!m.matches()) {
            throw this.invalidVersion(version);
        }
        this.major = Integer.parseInt(m.group(1));
        String minorStr = m.group(2);
        if (minorStr != null) {
            this.minor = Integer.parseInt(minorStr);
            String microStr = m.group(3);
            if (microStr != null) {
                this.micro = Integer.parseInt(microStr);
                this.qualifier = m.group(4);
            } else {
                this.micro = 0;
                this.qualifier = null;
            }
        } else {
            this.minor = 0;
            this.micro = 0;
            this.qualifier = null;
        }
    }

    private IllegalArgumentException invalidVersion(String input) {
        return new IllegalArgumentException("Invalid version, unable to parse: " + input);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int micro() {
        return this.micro;
    }

    public String qualifier() {
        return this.qualifier;
    }

    @Override
    public int compareTo(Version otherVersion) {
        int majorDiff = this.major - otherVersion.major();
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = this.minor - otherVersion.minor();
        if (minorDiff != 0) {
            return minorDiff;
        }
        int microDiff = this.micro - otherVersion.micro();
        if (microDiff != 0) {
            return microDiff;
        }
        if (this.qualifier == null) {
            if (otherVersion.qualifier != null) {
                return 1;
            }
        } else {
            if (otherVersion.qualifier == null) {
                return -1;
            }
            return this.qualifier.compareTo(otherVersion.qualifier);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Version other = (Version)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro + (this.qualifier == null ? "" : "." + this.qualifier);
    }
}

