/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.runtime;

import com.tc.util.runtime.UnknownJvmVersionException;
import com.tc.util.runtime.UnknownRuntimeVersionException;
import com.tc.util.runtime.VmVersion;

public class Vm {
    public static final VmVersion VERSION;

    private Vm() {
    }

    public static int getMegaVersion() {
        return VERSION.getMegaVersion();
    }

    public static int getMajorVersion() {
        return VERSION.getMajorVersion();
    }

    public static int getMinorVersion() {
        return VERSION.getMinorVersion();
    }

    public static String getPatchLevel() {
        return VERSION.getPatchLevel();
    }

    public static boolean isJDK14() {
        return VERSION.isJDK14();
    }

    public static boolean isJDK15() {
        return VERSION.isJDK15();
    }

    public static boolean isJDK16() {
        return VERSION.isJDK16();
    }

    public static boolean isJDK17() {
        return VERSION.isJDK17();
    }

    public static boolean isJDK15Compliant() {
        return VERSION.getMajorVersion() >= 5;
    }

    public static boolean isJDK16Compliant() {
        return VERSION.getMajorVersion() >= 6;
    }

    public static boolean isIBM() {
        if (VERSION == null) {
            return VmVersion.thisVMisIBM();
        }
        return VERSION.isIBM();
    }

    public static void assertIsIbm() {
        if (!Vm.isIBM()) {
            throw new AssertionError((Object)"not ibm");
        }
    }

    public static boolean isJRockit() {
        return VERSION.isJRockit();
    }

    public static boolean isAzul() {
        return VERSION.isAzul();
    }

    static {
        try {
            VERSION = new VmVersion(System.getProperties());
        }
        catch (UnknownJvmVersionException mve) {
            throw new RuntimeException(mve);
        }
        catch (UnknownRuntimeVersionException mve) {
            throw new RuntimeException(mve);
        }
    }
}

