/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.runtime;

import java.io.File;

public class Os {
    private Os() {
    }

    public static String getOsName() {
        return System.getProperty("os.name", "unknown");
    }

    public static String platform() {
        String osname = System.getProperty("os.name", "generic").toLowerCase();
        if (osname.startsWith("windows")) {
            return "win32";
        }
        if (osname.startsWith("linux")) {
            return "linux";
        }
        if (osname.startsWith("sunos")) {
            return "solaris";
        }
        if (osname.startsWith("mac") || osname.startsWith("darwin")) {
            return "mac";
        }
        if (osname.startsWith("aix")) {
            return "aix";
        }
        return "generic";
    }

    public static boolean isWindows() {
        return Os.getOsName().toLowerCase().indexOf("windows") >= 0;
    }

    public static boolean isLinux() {
        return Os.getOsName().toLowerCase().indexOf("linux") >= 0;
    }

    public static boolean isUnix() {
        String os = Os.getOsName().toLowerCase();
        if (os.indexOf("sunos") >= 0 || os.indexOf("linux") >= 0) {
            return true;
        }
        return Os.isMac() && System.getProperty("os.version", "").startsWith("10.");
    }

    public static boolean isMac() {
        String os = Os.getOsName().toLowerCase();
        return os.startsWith("mac") || os.startsWith("darwin");
    }

    public static boolean isSolaris() {
        String os = Os.getOsName().toLowerCase();
        return os.indexOf("sunos") >= 0;
    }

    public static boolean isAix() {
        return Os.getOsName().toLowerCase().indexOf("aix") >= 0;
    }

    public static String findWindowsSystemRoot() {
        if (!Os.isWindows()) {
            return null;
        }
        int begin = 99;
        int end = 122;
        for (char drive = 'c'; drive < 'z'; drive = (char)(drive + '\u0001')) {
            File root = new File(drive + ":\\WINDOWS");
            if (root.exists() && root.isDirectory()) {
                return root.getAbsolutePath().toString();
            }
            root = new File(drive + ":\\WINNT");
            if (!root.exists() || !root.isDirectory()) continue;
            return root.getAbsolutePath().toString();
        }
        return null;
    }
}

