/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import com.tc.util.Assert;

public class ThreadUtil {
    public static void reallySleep(long millis) {
        ThreadUtil.reallySleep(millis, 0);
    }

    public static void reallySleep(long millis, int nanos) {
        try {
            long start;
            for (long millisLeft = millis; millisLeft > 0L || nanos > 0; millisLeft -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                Thread.sleep(millisLeft, nanos);
                nanos = 0;
            }
        }
        catch (InterruptedException ie) {
            Assert.fail("Interrupted while attempting to sleep for " + millis + " millis and " + nanos + " nanos.");
        }
    }

    public static boolean tryToSleep(long millis) {
        boolean slept = false;
        try {
            Thread.sleep(millis);
            slept = true;
        }
        catch (InterruptedException ie) {
            slept = false;
        }
        return slept;
    }

    public static void printStackTrace(StackTraceElement[] ste) {
        for (int i = 0; i < ste.length; ++i) {
            System.err.println("\tat " + ste[i]);
        }
    }
}

