/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentedLRU<K, V> {
    private static final int DEFAULT_NUMBER_OF_SEGMENTS = 32;
    private final Map<K, V>[] segments;
    private final int segmentShift;
    private final int segmentMask;

    public SegmentedLRU(int capacity) {
        this(capacity, 32);
    }

    public SegmentedLRU(int capacity, int numberOfSegments) {
        int ssize;
        if (numberOfSegments < 2) {
            throw new IllegalArgumentException("Segment size should be 2 or greater");
        }
        int sshift = 0;
        for (ssize = 1; ssize < numberOfSegments; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Map[ssize];
        for (int i = 0; i < numberOfSegments; ++i) {
            this.segments[i] = Collections.synchronizedMap(new Segment((int)Math.ceil(capacity / numberOfSegments)));
        }
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private int getIndexFromKey(Object key) {
        int hash = SegmentedLRU.hash(key.hashCode());
        return hash >>> this.segmentShift & this.segmentMask;
    }

    private Map<K, V> segmentFor(K key) {
        int index = this.getIndexFromKey(key);
        return this.segments[index];
    }

    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    public boolean containsKey(K key) {
        return this.segmentFor(key).containsKey(key);
    }

    public boolean containsValue(Object value) {
        for (int i = 0; i < this.segments.length; ++i) {
            if (!this.segments[i].containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public V get(K key) {
        return this.segmentFor(key).get(key);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public V put(K key, V value) {
        return this.segmentFor(key).put(key, value);
    }

    public V remove(K key) {
        return this.segmentFor(key).remove(key);
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            size += this.segments[i].size();
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Segment
    extends LinkedHashMap<K, V> {
        private final int segmentCapacity;

        public Segment(int capacity) {
            super(capacity, 0.75f, true);
            this.segmentCapacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.segmentCapacity;
        }
    }
}

