/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.util.Assert;
import com.tc.util.ResourceBundleHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class ProductInfo {
    public static final String ENTERPRISE = "Enterprise";
    public static final String OPENSOURCE = "Opensource";
    private static final ResourceBundleHelper bundleHelper = new ResourceBundleHelper(ProductInfo.class);
    private static final String DATE_FORMAT = "yyyyMMdd-HHmmss";
    private static final Pattern KITIDPATTERN = Pattern.compile("(\\d+\\.\\d+).*");
    private static final String BUILD_DATA_RESOURCE_NAME = "/build-data.txt";
    private static final String PATCH_DATA_RESOURCE_NAME = "/patch-data.txt";
    private static final String BUILD_DATA_ROOT_KEY = "terracotta.build.";
    private static final String BUILD_DATA_VERSION_KEY = "version";
    private static final String BUILD_DATA_MAVEN_VERSION_KEY = "maven.artifacts.version";
    private static final String BUILD_DATA_API_VERSION_KEY = "api.version";
    private static final String BUILD_DATA_EDITION_KEY = "edition";
    private static final String BUILD_DATA_TIMESTAMP_KEY = "timestamp";
    private static final String BUILD_DATA_HOST_KEY = "host";
    private static final String BUILD_DATA_USER_KEY = "user";
    private static final String BUILD_DATA_REVISION_KEY = "revision";
    private static final String BUILD_DATA_EE_REVISION_KEY = "ee.revision";
    private static final String BUILD_DATA_BRANCH_KEY = "branch";
    private static final String PATCH_DATA_ROOT_KEY = "terracotta.patch.";
    private static final String PATCH_DATA_LEVEL_KEY = "level";
    public static final String UNKNOWN_VALUE = "[unknown]";
    public static final String DEFAULT_LICENSE = "Unlimited development";
    private static ProductInfo INSTANCE = null;
    private final String moniker;
    private final Date timestamp;
    private final String host;
    private final String user;
    private final String branch;
    private final String edition;
    private final String revision;
    private final String ee_revision;
    private final String kitID;
    private final String patchLevel;
    private final String patchHost;
    private final String patchUser;
    private final Date patchTimestamp;
    private final String patchRevision;
    private final String patchEERevision;
    private final String patchBranch;
    private final String mavenVersion;
    private final String apiVersion;
    private final String buildVersion;
    private String buildID;
    private String copyright;
    private final String license = "Unlimited development";

    ProductInfo(InputStream buildData, InputStream patchData) throws IOException, java.text.ParseException {
        Assert.assertNotNull("buildData", buildData);
        Properties properties = new Properties();
        this.moniker = bundleHelper.getString("moniker");
        properties.load(buildData);
        if (patchData != null) {
            properties.load(patchData);
        }
        this.buildVersion = this.getBuildProperty(properties, BUILD_DATA_VERSION_KEY, UNKNOWN_VALUE);
        this.mavenVersion = this.getBuildProperty(properties, BUILD_DATA_MAVEN_VERSION_KEY, UNKNOWN_VALUE);
        this.apiVersion = this.getBuildProperty(properties, BUILD_DATA_API_VERSION_KEY, UNKNOWN_VALUE);
        this.edition = this.getBuildProperty(properties, BUILD_DATA_EDITION_KEY, OPENSOURCE);
        if (!(this.isOpenSource() || this.isEnterprise() || this.isDevMode())) {
            throw new AssertionError((Object)("Can't recognize kit edition: " + this.edition));
        }
        this.timestamp = ProductInfo.parseTimestamp(this.getBuildProperty(properties, BUILD_DATA_TIMESTAMP_KEY, null));
        this.host = this.getBuildProperty(properties, BUILD_DATA_HOST_KEY, UNKNOWN_VALUE);
        this.user = this.getBuildProperty(properties, BUILD_DATA_USER_KEY, UNKNOWN_VALUE);
        this.branch = this.getBuildProperty(properties, BUILD_DATA_BRANCH_KEY, UNKNOWN_VALUE);
        this.revision = this.getBuildProperty(properties, BUILD_DATA_REVISION_KEY, UNKNOWN_VALUE);
        this.ee_revision = this.getBuildProperty(properties, BUILD_DATA_EE_REVISION_KEY, UNKNOWN_VALUE);
        this.patchLevel = this.getPatchProperty(properties, PATCH_DATA_LEVEL_KEY, UNKNOWN_VALUE);
        this.patchHost = this.getPatchProperty(properties, BUILD_DATA_HOST_KEY, UNKNOWN_VALUE);
        this.patchUser = this.getPatchProperty(properties, BUILD_DATA_USER_KEY, UNKNOWN_VALUE);
        this.patchTimestamp = ProductInfo.parseTimestamp(this.getPatchProperty(properties, BUILD_DATA_TIMESTAMP_KEY, null));
        this.patchRevision = this.getPatchProperty(properties, BUILD_DATA_REVISION_KEY, UNKNOWN_VALUE);
        this.patchEERevision = this.getPatchProperty(properties, BUILD_DATA_EE_REVISION_KEY, UNKNOWN_VALUE);
        this.patchBranch = this.getPatchProperty(properties, BUILD_DATA_BRANCH_KEY, UNKNOWN_VALUE);
        Matcher matcher = KITIDPATTERN.matcher(this.mavenVersion);
        this.kitID = matcher.matches() ? matcher.group(1) : UNKNOWN_VALUE;
    }

    static Date parseTimestamp(String timestampString) throws java.text.ParseException {
        return timestampString == null ? null : new SimpleDateFormat(DATE_FORMAT).parse(timestampString);
    }

    public static synchronized ProductInfo getInstance() {
        if (INSTANCE == null) {
            try {
                InputStream buildData = ProductInfo.getData(BUILD_DATA_RESOURCE_NAME);
                InputStream patchData = ProductInfo.getData(PATCH_DATA_RESOURCE_NAME);
                INSTANCE = new ProductInfo(buildData, patchData);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return INSTANCE;
    }

    static InputStream getData(String name) {
        return ProductInfo.class.getResourceAsStream(name);
    }

    static InputStream getBuildData() {
        return ProductInfo.getData(BUILD_DATA_RESOURCE_NAME);
    }

    static InputStream getPatchData() {
        return ProductInfo.getData(PATCH_DATA_RESOURCE_NAME);
    }

    private String getBuildProperty(Properties properties, String name, String defaultValue) {
        return this.getProperty(properties, BUILD_DATA_ROOT_KEY, name, defaultValue);
    }

    private String getPatchProperty(Properties properties, String name, String defaultValue) {
        return this.getProperty(properties, PATCH_DATA_ROOT_KEY, name, defaultValue);
    }

    private String getProperty(Properties properties, String root, String name, String defaultValue) {
        String out = properties.getProperty(root + name);
        if (StringUtils.isBlank((String)out)) {
            out = defaultValue;
        }
        return out;
    }

    public static void printRawData() {
        try {
            InputStream patchData;
            InputStream buildData = ProductInfo.getBuildData();
            if (buildData != null) {
                IOUtils.copy((InputStream)buildData, (OutputStream)System.out);
            }
            if ((patchData = ProductInfo.getPatchData()) != null) {
                IOUtils.copy((InputStream)patchData, (OutputStream)System.out);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isDevMode() {
        return this.buildVersion.endsWith(UNKNOWN_VALUE);
    }

    public String moniker() {
        return this.moniker;
    }

    public String edition() {
        return this.edition;
    }

    public String version() {
        return this.mavenVersion;
    }

    public String mavenArtifactsVersion() {
        return this.mavenVersion;
    }

    public String buildVersion() {
        return this.buildVersion;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String kitID() {
        return this.kitID;
    }

    public Date buildTimestamp() {
        return this.timestamp == null ? null : (Date)this.timestamp.clone();
    }

    public String buildTimestampAsString() {
        return this.timestamp == null ? UNKNOWN_VALUE : new SimpleDateFormat(DATE_FORMAT).format(this.timestamp);
    }

    public String buildHost() {
        return this.host;
    }

    public String buildUser() {
        return this.user;
    }

    public String buildBranch() {
        return this.branch;
    }

    public String copyright() {
        if (this.copyright == null) {
            this.copyright = bundleHelper.getString("copyright");
        }
        return this.copyright;
    }

    public String license() {
        return DEFAULT_LICENSE;
    }

    public String buildRevision() {
        return this.revision;
    }

    public String buildRevisionFromEE() {
        return this.ee_revision;
    }

    public boolean isPatched() {
        return !UNKNOWN_VALUE.equals(this.patchLevel);
    }

    public String patchLevel() {
        return this.patchLevel;
    }

    public String patchHost() {
        return this.patchHost;
    }

    public String patchUser() {
        return this.patchUser;
    }

    public Date patchTimestamp() {
        return this.patchTimestamp == null ? null : (Date)this.patchTimestamp.clone();
    }

    public String patchTimestampAsString() {
        return this.patchTimestamp == null ? UNKNOWN_VALUE : new SimpleDateFormat(DATE_FORMAT).format(this.patchTimestamp);
    }

    public String patchRevision() {
        return this.patchRevision;
    }

    public String patchEERevision() {
        return this.patchEERevision;
    }

    public String patchBranch() {
        return this.patchBranch;
    }

    public String toShortString() {
        return this.moniker + " " + (this.isOpenSource() ? "" : this.edition + " ") + this.buildVersion;
    }

    public String toLongString() {
        return this.toShortString() + ", as of " + this.buildID();
    }

    public String buildID() {
        if (this.buildID == null) {
            String rev = this.revision;
            if (this.isEnterprise()) {
                rev = this.ee_revision + "-" + this.revision;
            }
            this.buildID = this.buildTimestampAsString() + " (Revision " + rev + " by " + this.user + "@" + this.host + " from " + this.branch + ")";
        }
        return this.buildID;
    }

    public String toLongPatchString() {
        return this.toShortPatchString() + ", as of " + this.patchBuildID();
    }

    public String toShortPatchString() {
        return "Patch Level " + this.patchLevel;
    }

    public String patchBuildID() {
        String rev = this.patchRevision;
        if (this.isEnterprise()) {
            rev = this.patchEERevision + "-" + this.patchRevision;
        }
        return this.patchTimestampAsString() + " (Revision " + rev + " by " + this.patchUser + "@" + this.patchHost + " from " + this.patchBranch + ")";
    }

    public boolean isOpenSource() {
        return OPENSOURCE.equalsIgnoreCase(this.edition);
    }

    public boolean isEnterprise() {
        return ENTERPRISE.equalsIgnoreCase(this.edition);
    }

    public String toString() {
        return this.toShortString();
    }

    private static void printHelp(Options options) {
        new HelpFormatter().printHelp("java " + ProductInfo.class.getName(), options);
    }

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("v", "verbose", false, bundleHelper.getString("option.verbose"));
        options.addOption("r", "raw", false, bundleHelper.getString("option.raw"));
        options.addOption("h", "help", false, bundleHelper.getString("option.help"));
        GnuParser parser = new GnuParser();
        try {
            CommandLine cli = parser.parse(options, args);
            if (cli.hasOption("h")) {
                ProductInfo.printHelp(options);
                System.exit(0);
            }
            if (cli.hasOption("v")) {
                System.out.println(ProductInfo.getInstance().toLongString());
                if (ProductInfo.getInstance().isPatched()) {
                    System.out.println(ProductInfo.getInstance().toLongPatchString());
                }
                System.exit(0);
            }
            if (cli.hasOption("r")) {
                ProductInfo.printRawData();
                System.exit(0);
            }
            System.out.println(ProductInfo.getInstance().toShortString());
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            System.out.println();
            ProductInfo.printHelp(options);
            System.exit(1);
        }
    }
}

