/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.text.NonPortableReasonFormatter;
import com.tc.util.NonPortableDetail;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;

public class NonPortableReason
implements Serializable {
    private static final long serialVersionUID = 8149536931286184441L;
    public static final byte UNDEFINED = 0;
    public static final byte CLASS_NOT_ADAPTABLE = 1;
    public static final byte SUPER_CLASS_NOT_ADAPTABLE = 2;
    public static final byte SUBCLASS_OF_LOGICALLY_MANAGED_CLASS = 3;
    public static final byte CLASS_NOT_IN_BOOT_JAR = 4;
    public static final byte CLASS_NOT_INCLUDED_IN_CONFIG = 5;
    public static final byte SUPER_CLASS_NOT_INSTRUMENTED = 6;
    public static final byte TEST_REASON = 7;
    private static final byte LAST_DEFINED = 7;
    private final String className;
    private final List nonBootJarClasses;
    private final List bootJarClasses;
    private final Collection details;
    private final byte reason;
    private transient String detailedReason;
    private transient String instructions;
    private String message;
    private String ultimateNonPortableFieldName;

    public NonPortableReason(Class clazz, byte reasonCode) {
        this(clazz.getName(), reasonCode);
    }

    public NonPortableReason(String className, byte reasonCode) {
        this.className = className;
        this.reason = reasonCode;
        this.details = new LinkedList();
        this.nonBootJarClasses = new LinkedList();
        this.bootJarClasses = new LinkedList();
    }

    public String getClassName() {
        return this.className;
    }

    public synchronized String getDetailedReason() {
        if (this.detailedReason == null) {
            this.detailedReason = this.constructDetailedReason();
        }
        return this.detailedReason;
    }

    public synchronized String getInstructions() {
        if (this.instructions == null) {
            this.instructions = this.constructInstructions();
        }
        return this.instructions;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.checkSanity();
        out.defaultWriteObject();
    }

    public void addDetail(String label, String value) {
        this.details.add(new NonPortableDetail(label, value));
    }

    private String constructDetailedReason() {
        boolean hasPreamble = this.message != null;
        StringBuffer sb = this.message == null ? new StringBuffer() : new StringBuffer(this.message);
        switch (this.reason) {
            case 1: {
                if (hasPreamble) {
                    sb.append(" This unshareable class is a");
                } else {
                    sb.append("Attempted to share a");
                }
                sb.append(" JVM- or host machine-specific resource. Please ensure that instances of this class don't enter the shared object graph.");
                this.addDetail("Unshareable class", this.className);
                break;
            }
            case 2: {
                if (hasPreamble) {
                    sb.append(" This unshareable class is a");
                } else {
                    sb.append("Attempted to share an instance of a class that is a");
                }
                sb.append(" subclass of a JVM- or host machine-specific resource.");
                sb.append(" Please either modify the class hierarchy or ensure that instances of this class don't enter the shared object graph.");
                this.addDetail("Unshareable superclass names", this.getErroneousSuperClassNames());
                break;
            }
            case 3: {
                if (hasPreamble) {
                    sb.append(" This unshareable class");
                } else {
                    sb.append("Attempted to share an instance of a class which");
                }
                sb.append(" has a logically-managed superclass.");
                sb.append(" Subclasses of logically-managed classes cannot be shared. Please either");
                sb.append(" modify the class hierarchy or ensure that instances of this class don't enter the shared object graph.");
                this.addDetail("Unshareable class", this.className);
                this.addDetail("Logically-managed superclass names", this.getErroneousSuperClassNames());
                break;
            }
            case 4: {
                if (hasPreamble) {
                    sb.append(" This unshareable class");
                } else {
                    sb.append("Attempted to share an instance of a class which");
                }
                if (!this.bootJarClasses.isEmpty()) {
                    sb.append(" must be in the DSO boot jar.  It also has superclasses which must be in the DSO boot jar.  Please add all of these classes to the boot jar configuration and re-create the DSO boot jar.");
                    ArrayList<String> classes = new ArrayList<String>();
                    classes.addAll(this.bootJarClasses);
                    classes.add(this.className);
                    this.addDetail("Classes to add to boot jar", NonPortableReason.csvList(classes));
                    break;
                }
                sb.append(" must be in the DSO boot jar. Please add this class to the boot jar configuration and re-create the DSO boot jar.");
                this.addDetail("Class to add to boot jar", this.className);
                break;
            }
            case 6: {
                if (hasPreamble) {
                    sb.append(" This unshareable class has");
                } else {
                    sb.append("Attempted to share an instance of a class which has");
                }
                boolean plural = this.bootJarClasses.size() + this.nonBootJarClasses.size() > 1;
                sb.append(plural ? " super-classes" : " a super-class");
                sb.append(" that" + (plural ? " are" : " is") + " uninstrumented." + "  Subclasses of uninstrumented classes cannot be shared.");
                this.addDetail("Unshareable class", this.className);
                if (!this.bootJarClasses.isEmpty()) {
                    this.addDetail("Classes to add to boot jar", NonPortableReason.csvList(this.bootJarClasses));
                }
                if (this.nonBootJarClasses.isEmpty()) break;
                this.addDetail("Classes to add to the <includes> configuration", NonPortableReason.csvList(this.nonBootJarClasses));
                break;
            }
            case 5: {
                if (hasPreamble) {
                    sb.append(" This unshareable class");
                } else {
                    sb.append("Attempted to share an instance of a class which");
                }
                sb.append(" has not been included for sharing in the configuration.");
                if (!this.nonBootJarClasses.isEmpty()) {
                    LinkedList<String> classes = new LinkedList<String>();
                    classes.add(this.className);
                    classes.addAll(this.nonBootJarClasses);
                    this.addDetail("Non-included classes", NonPortableReason.csvList(classes));
                } else {
                    this.addDetail("Non-included class", this.className);
                }
                if (this.bootJarClasses.isEmpty()) break;
                if (this.bootJarClasses.size() == 1) {
                    this.addDetail("Class to add to boot jar", NonPortableReason.csvList(this.bootJarClasses));
                    break;
                }
                this.addDetail("Classes to add to boot jar", NonPortableReason.csvList(this.bootJarClasses));
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown reason: " + this.reason));
            }
        }
        return sb.toString();
    }

    private String constructInstructions() {
        StringBuffer sb = new StringBuffer();
        switch (this.reason) {
            case 1: {
                boolean isRoot;
                NonPortableDetail detail = this.findDetailByLabel("Non-portable root name");
                boolean bl = isRoot = detail != null;
                if (detail == null) {
                    detail = this.findDetailByLabel("Non-portable field name");
                }
                sb.append(Messages.classNotAdaptableInstructions(detail != null ? detail.getValue() : null, this.className, isRoot));
                break;
            }
            case 2: {
                boolean isRoot;
                NonPortableDetail detail = this.findDetailByLabel("Non-portable root name");
                boolean bl = isRoot = detail != null;
                if (detail == null) {
                    detail = this.findDetailByLabel("Non-portable field name");
                }
                if (detail == null) {
                    detail = this.findDetailByLabel("Referring field");
                }
                sb.append(Messages.superClassNotAdaptableInstructions(detail != null ? detail.getValue() : null, this.className, this.getErroneousSuperClassNames(), isRoot));
                break;
            }
            case 3: {
                boolean isRoot;
                NonPortableDetail detail = this.findDetailByLabel("Non-portable root name");
                boolean bl = isRoot = detail != null;
                if (detail == null) {
                    detail = this.findDetailByLabel("Non-portable field name");
                }
                sb.append(Messages.subclassOfLogicallyManagedClassInstructions(detail != null ? detail.getValue() : null, this.className, this.getErroneousSuperClassNames(), isRoot));
                break;
            }
            case 4: {
                LinkedList<String> classes = new LinkedList<String>();
                classes.addAll(this.bootJarClasses);
                classes.add(this.className);
                sb.append(Messages.classNotInBootJarInstructions(classes));
                break;
            }
            case 5: {
                LinkedList<String> normalClasses = new LinkedList<String>();
                normalClasses.add(this.className);
                if (this.nonBootJarClasses != null) {
                    normalClasses.addAll(this.nonBootJarClasses);
                }
                sb.append(Messages.classNotIncludedInConfigInstructions(normalClasses, this.bootJarClasses));
                break;
            }
            case 6: {
                sb.append(Messages.superClassNotInstrumentedInstructions(this.nonBootJarClasses, this.bootJarClasses));
                break;
            }
            case 7: {
                sb.append("instructions");
            }
        }
        return sb.toString();
    }

    public boolean hasUltimateNonPortableFieldName() {
        return this.ultimateNonPortableFieldName != null;
    }

    public void setUltimateNonPortableFieldName(String name) {
        this.addDetail("Referring field", name);
        this.ultimateNonPortableFieldName = name;
    }

    public String getUltimateNonPortableFieldName() {
        return this.ultimateNonPortableFieldName;
    }

    private String getErroneousSuperClassNames() {
        LinkedList supers = new LinkedList(this.nonBootJarClasses);
        supers.addAll(this.bootJarClasses);
        return NonPortableReason.csvList(supers);
    }

    private static String csvList(Collection list) {
        StringBuffer sb = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private void checkSanity() {
        if (this.reason <= 0 || this.reason > 7) {
            throw new AssertionError((Object)"Please specify the reason for Non-portability by calling setReason() with one of the defined reasons.");
        }
        if ((this.reason == 3 || this.reason == 2 || this.reason == 6) && this.nonBootJarClasses.size() == 0 && this.bootJarClasses.size() == 0) {
            throw new AssertionError((Object)"Please add erroneous super classes by calling addErroneousSuperClass()");
        }
    }

    public byte getReason() {
        return this.reason;
    }

    public void addErroneousSuperClass(Class superClass) {
        if (superClass.getClassLoader() == null) {
            this.bootJarClasses.add(superClass.getName());
        } else {
            this.nonBootJarClasses.add(superClass.getName());
        }
    }

    public List getErroneousSuperClasses() {
        return this.nonBootJarClasses;
    }

    public List getErroneousBootJarSuperClasses() {
        return this.bootJarClasses;
    }

    public String toString() {
        return this.getDetailedReason();
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    public void accept(NonPortableReasonFormatter formatter) {
        formatter.formatReasonText(this.getDetailedReason());
        Iterator i = this.details.iterator();
        while (i.hasNext()) {
            formatter.formatDetail((NonPortableDetail)i.next());
        }
        formatter.formatInstructionsText(this.getInstructions());
    }

    private NonPortableDetail findDetailByLabel(String label) {
        for (NonPortableDetail detail : this.details) {
            if (!label.equals(detail.getLabel())) continue;
            return detail;
        }
        return null;
    }

    private static final class Messages {
        private static final ResourceBundle rb = ResourceBundle.getBundle(NonPortableReason.class.getName());
        private static final String CLASS_NOT_ADAPTABLE_ROOT_INSTRUCTIONS_KEY = "classNotAdaptable.root.instructions";
        private static final String CLASS_NOT_ADAPTABLE_FIELD_INSTRUCTIONS_KEY = "classNotAdaptable.field.instructions";
        private static final String SUPER_CLASS_NOT_ADAPTABLE_ROOT_INSTRUCTIONS_KEY = "superClassNotAdaptable.root.instructions";
        private static final String SUPER_CLASS_NOT_ADAPTABLE_FIELD_INSTRUCTIONS_KEY = "superClassNotAdaptable.field.instructions";
        private static final String SUBCLASS_OF_LOGICALLY_MANAGED_CLASS_ROOT_INSTRUCTIONS_KEY = "logicallyManagedSuperClass.root.instructions";
        private static final String SUBCLASS_OF_LOGICALLY_MANAGED_CLASS_FIELD_INSTRUCTIONS_KEY = "logicallyManagedSuperClass.field.instructions";
        private static final String CLASS_NOT_IN_BOOT_JAR_INFO_KEY = "classNotInBootJar.info";
        private static final String CLASS_NOT_IN_BOOT_JAR_CLASS_KEY = "classNotInBootJar.class";
        private static final String CLASS_NOT_IN_BOOT_JAR_INSTRUCTIONS_KEY = "classNotInBootJar.instructions";
        private static final String CLASS_NOT_INCLUDED_IN_CONFIG_INFO_KEY = "classNotIncludedInConfig.info";
        private static final String CLASS_NOT_INCLUDED_IN_CONFIG_HEADER_KEY = "classNotIncludedInConfig.header";
        private static final String CLASS_NOT_INCLUDED_IN_CONFIG_NON_BOOTJAR_CLASS_KEY = "classNotIncludedInConfig.non-bootjar.class";
        private static final String CLASS_NOT_INCLUDED_IN_CONFIG_NON_BOOTJAR_INSTRUCTIONS_KEY = "classNotIncludedInConfig.non-bootjar.instructions";
        private static final String CLASS_NOT_INCLUDED_IN_CONFIG_BOOTJAR_CLASS_KEY = "classNotIncludedInConfig.bootjar.class";
        private static final String CLASS_NOT_INCLUDED_IN_CONFIG_BOOTJAR_INSTRUCTIONS_KEY = "classNotIncludedInConfig.bootjar.instructions";
        private static final String SUPER_CLASS_NOT_INSTRUMENTED_INFO_KEY = "superClassNotInstrumented.info";
        private static final String SUPER_CLASS_NOT_INSTRUMENTED_HEADER_KEY = "superClassNotInstrumented.header";
        private static final String SUPER_CLASS_NOT_INSTRUMENTED_NON_BOOTJAR_CLASS_KEY = "superClassNotInstrumented.non-bootjar.class";
        private static final String SUPER_CLASS_NOT_INSTRUMENTED_NON_BOOTJAR_INSTRUCTIONS_KEY = "superClassNotInstrumented.non-bootjar.instructions";
        private static final String SUPER_CLASS_NOT_INSTRUMENTED_BOOTJAR_CLASS_KEY = "superClassNotInstrumented.bootjar.class";
        private static final String SUPER_CLASS_NOT_INSTRUMENTED_BOOTJAR_INSTRUCTIONS_KEY = "superClassNotInstrumented.bootjar.instructions";

        private Messages() {
        }

        static String classNotAdaptableInstructions(String fieldName, String nonAdaptableClassName, boolean isRootField) {
            return MessageFormat.format(rb.getString(isRootField ? CLASS_NOT_ADAPTABLE_ROOT_INSTRUCTIONS_KEY : CLASS_NOT_ADAPTABLE_FIELD_INSTRUCTIONS_KEY), fieldName, nonAdaptableClassName);
        }

        static String superClassNotAdaptableInstructions(String fieldName, String nonAdaptableSubclass, String nonAdaptableSuperClasses, boolean isRootField) {
            return MessageFormat.format(rb.getString(isRootField ? SUPER_CLASS_NOT_ADAPTABLE_ROOT_INSTRUCTIONS_KEY : SUPER_CLASS_NOT_ADAPTABLE_FIELD_INSTRUCTIONS_KEY), fieldName, nonAdaptableSubclass, nonAdaptableSuperClasses);
        }

        static String subclassOfLogicallyManagedClassInstructions(String fieldName, String nonAdaptableSubclass, String logicallyManagedSuperClasses, boolean isRootField) {
            return MessageFormat.format(rb.getString(isRootField ? SUBCLASS_OF_LOGICALLY_MANAGED_CLASS_ROOT_INSTRUCTIONS_KEY : SUBCLASS_OF_LOGICALLY_MANAGED_CLASS_FIELD_INSTRUCTIONS_KEY), fieldName, nonAdaptableSubclass, logicallyManagedSuperClasses);
        }

        static String classNotInBootJarInstructions(List classes) {
            StringBuffer instructions = new StringBuffer(MessageFormat.format(rb.getString(CLASS_NOT_IN_BOOT_JAR_INFO_KEY), null));
            StringBuffer classesMsg = new StringBuffer();
            Iterator pos = classes.iterator();
            while (pos.hasNext()) {
                classesMsg.append(MessageFormat.format(rb.getString(CLASS_NOT_IN_BOOT_JAR_CLASS_KEY), pos.next()));
            }
            instructions.append(MessageFormat.format(rb.getString(CLASS_NOT_IN_BOOT_JAR_INSTRUCTIONS_KEY), classesMsg));
            return instructions.toString();
        }

        static String classNotIncludedInConfigInstructions(List normalClassNames, List bootJarClassNames) {
            Iterator pos;
            StringBuffer instructions = new StringBuffer(MessageFormat.format(rb.getString(CLASS_NOT_INCLUDED_IN_CONFIG_INFO_KEY), null));
            instructions.append(MessageFormat.format(rb.getString(CLASS_NOT_INCLUDED_IN_CONFIG_HEADER_KEY), null));
            if (normalClassNames != null && !normalClassNames.isEmpty()) {
                StringBuffer classList = new StringBuffer();
                pos = normalClassNames.iterator();
                while (pos.hasNext()) {
                    classList.append(MessageFormat.format(rb.getString(CLASS_NOT_INCLUDED_IN_CONFIG_NON_BOOTJAR_CLASS_KEY), pos.next()));
                }
                instructions.append(MessageFormat.format(rb.getString(CLASS_NOT_INCLUDED_IN_CONFIG_NON_BOOTJAR_INSTRUCTIONS_KEY), classList));
            }
            if (bootJarClassNames != null && !bootJarClassNames.isEmpty()) {
                StringBuffer bootJarClassList = new StringBuffer();
                pos = bootJarClassNames.iterator();
                while (pos.hasNext()) {
                    bootJarClassList.append(MessageFormat.format(rb.getString(CLASS_NOT_INCLUDED_IN_CONFIG_BOOTJAR_CLASS_KEY), pos.next()));
                }
                instructions.append(MessageFormat.format(rb.getString(CLASS_NOT_INCLUDED_IN_CONFIG_BOOTJAR_INSTRUCTIONS_KEY), bootJarClassList));
            }
            return instructions.toString();
        }

        static String superClassNotInstrumentedInstructions(List normalClassNames, List bootJarClassNames) {
            Iterator pos;
            StringBuffer instructions = new StringBuffer(MessageFormat.format(rb.getString(SUPER_CLASS_NOT_INSTRUMENTED_INFO_KEY), null));
            instructions.append(MessageFormat.format(rb.getString(SUPER_CLASS_NOT_INSTRUMENTED_HEADER_KEY), null));
            if (normalClassNames != null && !normalClassNames.isEmpty()) {
                StringBuffer classList = new StringBuffer();
                pos = normalClassNames.iterator();
                while (pos.hasNext()) {
                    classList.append(MessageFormat.format(rb.getString(SUPER_CLASS_NOT_INSTRUMENTED_NON_BOOTJAR_CLASS_KEY), pos.next()));
                }
                instructions.append(MessageFormat.format(rb.getString(SUPER_CLASS_NOT_INSTRUMENTED_NON_BOOTJAR_INSTRUCTIONS_KEY), classList));
            }
            if (bootJarClassNames != null && !bootJarClassNames.isEmpty()) {
                StringBuffer bootJarClassList = new StringBuffer();
                pos = bootJarClassNames.iterator();
                while (pos.hasNext()) {
                    bootJarClassList.append(MessageFormat.format(rb.getString(SUPER_CLASS_NOT_INSTRUMENTED_BOOTJAR_CLASS_KEY), pos.next()));
                }
                instructions.append(MessageFormat.format(rb.getString(SUPER_CLASS_NOT_INSTRUMENTED_BOOTJAR_INSTRUCTIONS_KEY), bootJarClassList));
            }
            return instructions.toString();
        }
    }
}

