/*
 * Decompiled with CFR 0.152.
 */
package com.tc.text;

import com.tc.text.NonPortableReasonFormatter;
import com.tc.text.ParagraphFormatter;
import com.tc.text.StringFormatter;
import com.tc.util.NonPortableDetail;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class ConsoleNonPortableReasonFormatter
implements NonPortableReasonFormatter {
    private final PrintWriter out;
    private final StringFormatter stringFormatter;
    private final Collection details;
    private String instructions;
    private int maxLabelLength;
    private final String separator;
    private final ParagraphFormatter paragraphFormatter;

    public ConsoleNonPortableReasonFormatter(PrintWriter out, String separator, StringFormatter stringFormatter, ParagraphFormatter paragraphFormatter) {
        this.out = out;
        this.separator = separator;
        this.stringFormatter = stringFormatter;
        this.paragraphFormatter = paragraphFormatter;
        this.details = new LinkedList();
    }

    public void formatReasonTypeName(byte type) {
        String name;
        switch (type) {
            case 1: {
                name = "CLASS_NOT_ADAPTABLE";
                break;
            }
            case 2: {
                name = "SUPER_CLASS_NOT_ADAPTABLE";
                break;
            }
            case 3: {
                name = "SUBCLASS_OF_LOGICALLY_MANAGED_CLASS";
                break;
            }
            case 4: {
                name = "CLASS_NOT_IN_BOOT_JAR";
                break;
            }
            case 5: {
                name = "CLASS_NOT_INCLUDED_IN_CONFIG";
                break;
            }
            case 6: {
                name = "SUPER_CLASS_NOT_INSTRUMENTED";
                break;
            }
            default: {
                name = "UNDEFINED";
            }
        }
        this.out.print(name);
    }

    public void formatDetail(NonPortableDetail detail) {
        this.details.add(detail);
        if (detail.getLabel().length() > this.maxLabelLength) {
            this.maxLabelLength = detail.getLabel().length();
        }
    }

    public void flush() {
        Iterator i = this.details.iterator();
        while (i.hasNext()) {
            NonPortableDetail detail = (NonPortableDetail)i.next();
            this.out.print(this.stringFormatter.rightPad(this.maxLabelLength, (Object)detail.getLabel()));
            this.out.print(this.separator);
            this.out.print(detail.getValue());
            if (!i.hasNext()) continue;
            this.out.println();
        }
        this.details.clear();
        if (this.instructions != null) {
            this.out.println();
            this.out.print(this.instructions);
        }
        this.out.flush();
    }

    public void formatReasonText(String reasonText) {
        if (null == reasonText || 0 == reasonText.length()) {
            return;
        }
        this.out.println(this.paragraphFormatter.format(reasonText));
        this.out.println();
        this.out.println("For more information on this issue, please visit our Troubleshooting Guide at:");
        this.out.println("http://terracotta.org/kit/troubleshooting");
        this.out.println();
    }

    public void formatInstructionsText(String instructionsText) {
        if (null == instructionsText || 0 == instructionsText.length()) {
            this.instructions = null;
        }
        this.instructions = instructionsText;
    }
}

