/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats.counter.sampled;

import com.tc.stats.counter.CounterImpl;
import com.tc.stats.counter.sampled.SampledCounter;
import com.tc.stats.counter.sampled.SampledCounterConfig;
import com.tc.stats.counter.sampled.TimeStampedCounterValue;
import com.tc.util.concurrent.CircularLossyQueue;
import java.util.TimerTask;

public class SampledCounterImpl
extends CounterImpl
implements SampledCounter {
    protected final CircularLossyQueue<TimeStampedCounterValue> history;
    protected final boolean resetOnSample;
    private final TimerTask samplerTask;
    private final long intervalMillis;

    public SampledCounterImpl(SampledCounterConfig config) {
        super(config.getInitialValue());
        this.intervalMillis = config.getIntervalSecs() * 1000;
        this.history = new CircularLossyQueue(config.getHistorySize());
        this.resetOnSample = config.isResetOnSample();
        this.samplerTask = new TimerTask(){

            public void run() {
                SampledCounterImpl.this.recordSample();
            }
        };
        this.recordSample();
    }

    public TimeStampedCounterValue getMostRecentSample() {
        return this.history.peek();
    }

    public TimeStampedCounterValue[] getAllSampleValues() {
        return this.history.toArray((TimeStampedCounterValue[])new TimeStampedCounterValue[this.history.depth()]);
    }

    public void shutdown() {
        if (this.samplerTask != null) {
            this.samplerTask.cancel();
        }
    }

    public TimerTask getTimerTask() {
        return this.samplerTask;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    void recordSample() {
        long sample = this.resetOnSample ? this.getAndReset() : this.getValue();
        long now = System.currentTimeMillis();
        TimeStampedCounterValue timedSample = new TimeStampedCounterValue(now, sample);
        this.history.push(timedSample);
    }

    public long getAndReset() {
        return this.getAndSet(0L);
    }
}

