/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats.counter;

import com.tc.stats.counter.Counter;
import com.tc.stats.counter.CounterConfig;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.sampled.SampledCounter;
import com.tc.stats.counter.sampled.SampledCounterImpl;
import java.util.Timer;

public class CounterManagerImpl
implements CounterManager {
    private final Timer timer = new Timer("SampledCounterManager Timer", true);
    private boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        try {
            this.timer.cancel();
        }
        finally {
            this.shutdown = true;
        }
    }

    public synchronized Counter createCounter(CounterConfig config) {
        if (this.shutdown) {
            throw new IllegalStateException("counter manager is shutdown");
        }
        if (config == null) {
            throw new NullPointerException("config cannot be null");
        }
        Counter counter = config.createCounter();
        if (counter instanceof SampledCounterImpl) {
            SampledCounterImpl sampledCounter = (SampledCounterImpl)counter;
            this.timer.schedule(sampledCounter.getTimerTask(), sampledCounter.getIntervalMillis(), sampledCounter.getIntervalMillis());
        }
        return counter;
    }

    public void shutdownCounter(Counter counter) {
        if (counter instanceof SampledCounter) {
            SampledCounter sc = (SampledCounter)counter;
            sc.shutdown();
        }
    }
}

