/*
 * Decompiled with CFR 0.152.
 */
package com.tc.process;

import com.tc.process.StreamAppender;
import com.tc.process.StreamCollector;
import com.tc.util.runtime.Os;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class Exec {
    public static String getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            throw new IllegalStateException("java.home system property not set");
        }
        File home = new File(javaHome);
        Exec.ensureDir(home);
        File bin = new File(home, "bin");
        Exec.ensureDir(bin);
        File java = new File(bin, "java" + (Os.isWindows() ? ".exe" : ""));
        if (java.exists() && java.canRead()) {
            return java.getAbsolutePath();
        }
        throw new AssertionError((Object)(java.getAbsolutePath() + " cannot be read or does not exist"));
    }

    public static Result execute(String[] cmd) throws Exception {
        return Exec.execute(cmd, null, null, null);
    }

    public static Result execute(String[] cmd, String outputLog) throws Exception {
        return Exec.execute(cmd, outputLog, null, null);
    }

    public static Result execute(String[] cmd, String outputLog, byte[] input) throws Exception {
        return Exec.execute(cmd, outputLog, input, null);
    }

    public static Result execute(String[] cmd, String outputLog, byte[] input, File workingDir) throws Exception {
        Process process = Runtime.getRuntime().exec(cmd, null, workingDir);
        return Exec.execute(process, cmd, outputLog, input, workingDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result execute(Process process, String[] cmd, String outputLog, byte[] input, File workingDir) throws Exception {
        Result result;
        InputPumper inputThread = new InputPumper(input == null ? new byte[]{} : input, process.getOutputStream());
        StreamCollector stderr = null;
        StreamCollector stdout = null;
        FileOutputStream fileOutput = null;
        StreamAppender outputLogger = null;
        String errString = null;
        String outString = null;
        try {
            if (outputLog != null) {
                errString = "stderr output redirected to file " + outputLog;
                outString = "stdout output redirected to file " + outputLog;
                fileOutput = new FileOutputStream(outputLog);
                outputLogger = new StreamAppender(fileOutput);
                outputLogger.writeInput(process.getErrorStream(), process.getInputStream());
            } else {
                stderr = new StreamCollector(process.getErrorStream());
                stdout = new StreamCollector(process.getInputStream());
                stderr.start();
                stdout.start();
            }
            inputThread.start();
            int exitCode = process.waitFor();
            inputThread.join();
            if (outputLogger != null) {
                outputLogger.finish();
            }
            if (stderr != null) {
                stderr.join();
                errString = stderr.toString();
            }
            if (stdout != null) {
                stdout.join();
                outString = stdout.toString();
            }
            result = new Result(cmd, outString, errString, exitCode);
        }
        catch (Throwable throwable) {
            Exec.closeQuietly(fileOutput);
            throw throwable;
        }
        Exec.closeQuietly(fileOutput);
        return result;
    }

    private static void closeQuietly(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void ensureDir(File dir) {
        if (!dir.exists()) {
            throw new AssertionError((Object)(dir + " does not exist"));
        }
        if (!dir.isDirectory()) {
            throw new AssertionError((Object)(dir + " is not a directory"));
        }
        if (!dir.canRead()) {
            throw new AssertionError((Object)(dir + " is not readable"));
        }
    }

    public static class Result {
        private final String stderr;
        private final String stdout;
        private final int exitCode;
        private final String[] cmd;

        private Result(String[] cmd, String stdout, String stderr, int exitCode) {
            this.cmd = cmd;
            this.stdout = stdout;
            this.stderr = stderr;
            this.exitCode = exitCode;
        }

        public String getStderr() {
            return this.stderr;
        }

        public String getStdout() {
            return this.stdout;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String toString() {
            return "Command: " + Arrays.asList(this.cmd) + "\n" + "exit code: " + this.exitCode + "\n" + "stdout: " + this.stdout + "\n" + "stderr: " + this.stderr + "\n";
        }
    }

    private static class InputPumper
    extends Thread {
        private final InputStream data;
        private final OutputStream output;

        InputPumper(byte[] input, OutputStream output) {
            this.output = output;
            this.data = new ByteArrayInputStream(input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                IOUtils.copy((InputStream)this.data, (OutputStream)this.output);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Exec.closeQuietly(this.output);
            }
        }
    }
}

