/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dmi;

import com.tc.async.api.EventContext;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.ObjectID;
import com.tc.object.dmi.DmiClassSpec;
import com.tc.util.Assert;
import java.io.IOException;

public class DmiDescriptor
implements TCSerializable,
EventContext {
    public static final DmiDescriptor[] EMPTY_ARRAY = new DmiDescriptor[0];
    private ObjectID receiverId;
    private ObjectID dmiCallId;
    private DmiClassSpec[] classSpecs;
    private boolean faultReceiver;

    public DmiDescriptor() {
        this.receiverId = null;
        this.dmiCallId = null;
    }

    public DmiDescriptor(ObjectID receiverId, ObjectID dmiCallId, DmiClassSpec[] classSpecs, boolean faultReceiver) {
        Assert.pre(receiverId != null);
        Assert.pre(dmiCallId != null);
        Assert.pre(classSpecs != null);
        this.receiverId = receiverId;
        this.dmiCallId = dmiCallId;
        this.classSpecs = classSpecs;
        this.faultReceiver = faultReceiver;
    }

    public ObjectID getReceiverId() {
        return this.receiverId;
    }

    public ObjectID getDmiCallId() {
        return this.dmiCallId;
    }

    public DmiClassSpec[] getClassSpecs() {
        return this.classSpecs;
    }

    public boolean isFaultReceiver() {
        return this.faultReceiver;
    }

    public String toString() {
        return "DmiDescriptor{receiverId=" + this.receiverId + ", dmiCallId=" + this.dmiCallId + ", ClassSpecs=" + DmiClassSpec.toString(this.classSpecs) + "}";
    }

    public Object deserializeFrom(TCByteBufferInput in) throws IOException {
        this.receiverId = new ObjectID(in.readLong());
        this.dmiCallId = new ObjectID(in.readLong());
        this.faultReceiver = in.readBoolean();
        int size = in.readInt();
        this.classSpecs = new DmiClassSpec[size];
        for (int i = 0; i < this.classSpecs.length; ++i) {
            String classLoaderDesc = in.readString();
            String className = in.readString();
            this.classSpecs[i] = new DmiClassSpec(classLoaderDesc, className);
        }
        return this;
    }

    public void serializeTo(TCByteBufferOutput out) {
        out.writeLong(this.receiverId.toLong());
        out.writeLong(this.dmiCallId.toLong());
        out.writeBoolean(this.faultReceiver);
        out.writeInt(this.classSpecs.length);
        for (int i = 0; i < this.classSpecs.length; ++i) {
            out.writeString(this.classSpecs[i].getClassLoaderDesc());
            out.writeString(this.classSpecs[i].getClassName());
        }
    }
}

